% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_model.R
\name{cv_model}
\alias{cv_model}
\title{K-fold cross-validation for models}
\usage{
cv_model(
  formula,
  data,
  k = 5,
  fit_function = "lm",
  metric = if (length(unique(data[, as.character(formula)[2]])) == 2) "AUC" else "RMSE",
  predict.control = list(NULL),
  ...
)
}
\arguments{
\item{formula}{An object of class "formula" describing the model to be validated}

\item{data}{A data frame containing the variables specified in formula argument}

\item{k}{Number of folds}

\item{fit_function}{Name of the model fitting function}

\item{metric}{Performance metric to estimate: RMSE, MSE, MAE  or AUC}

\item{predict.control}{Named list of arguments to pass to the predict function of the model}

\item{...}{Further arguments passed to the model fitting function}
}
\value{
Cross-validated values for the selected performance metric
}
\description{
Returns cross-validated absolute fit values
}
\examples{
cv_model(Petal.Length ~ Sepal.Width + Species, data=iris)
}
