% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_Date.R
\name{eedate_to_rdate}
\alias{eedate_to_rdate}
\title{Pass an Earth Engine date object to R}
\usage{
eedate_to_rdate(ee_date, timestamp = FALSE)
}
\arguments{
\item{ee_date}{ee$date object (ee$Date)}

\item{timestamp}{Logical. If TRUE, return the date in milliseconds
from the Unix Epoch (1970-01-01 00:00:00 UTC). Otherwise, return the
date as a POSIXct object. By default FALSE.}
}
\value{
\code{eedate_to_rdate} will return either a numeric timestamp or
a POSIXct object depending on the \code{timestamp} argument.
}
\description{
Pass an Earth Engine date object to R
}
\details{
\code{eedate_to_rdate} is essential to avoid potential errors that
might appear when users need to retrieve dates. Currently,
R integer only supports 32 bit signed (such integers can only
count up to about 2 billion). This range is notably insufficient for dealing
with GEE date objects represented by timestamps in milliseconds since the
UNIX epoch. \code{eedate_to_rdate} uses Python in the backend to obtain the
date and convert it in float before exporting to R.
}
\examples{
\dontrun{
library(rgee)
ee_Initialize()

eeDate <- ee$Date$fromYMD(2010,1,1)
eedate_to_rdate(eeDate,timestamp = TRUE) # good
eeDate$getInfo()$value # bad
}
}
\seealso{
Other date functions: 
\code{\link{ee_get_date_ic}()},
\code{\link{ee_get_date_img}()},
\code{\link{rdate_to_eedate}()}
}
\concept{date functions}
