% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite.R
\name{gd_composite}
\alias{gd_composite}
\title{Composite an Image Collection}
\usage{
gd_composite(x, ...)
}
\arguments{
\item{x}{an object inheriting from \code{geedim.collection.ImageCollectionAccessor} (for geedim >= 2.0.0) or \code{geedim.collection.MaskedCollection} (for geedim < 2.0.0), such as from \code{gd_search()} or \code{gd_collection_from_list()}. See \verb{\link{geedim-versions}} for more details.}

\item{...}{\href{https://geedim.readthedocs.io/en/stable/reference/api.html#geedim.collection.ImageCollectionAccessor.composite}{additional arguments} to \code{geedim.collection.ImageCollectionAccessor$composite()}}
}
\value{
a composite \code{ee.image.Image} object
}
\description{
Create a composite image from elements of an image collection.
}
\examples{
\dontshow{if (isTRUE(as.logical(Sys.getenv("R_RGEEDIM_RUN_EXAMPLES"))) && gd_is_initialized() && !inherits(requireNamespace("terra", quietly=TRUE), 'try-error')) withAutoprint(\{ # examplesIf}
\donttest{
library(terra)

b <- terra::vect('POLYGON((-121.355 37.560, 
                           -121.355 37.555,
                           -121.350 37.555, 
                           -121.350 37.560,
                           -121.355 37.560))',
                 crs = "OGC:CRS84")

if (gd_is_initialized())
  gd_composite(gd_search(gd_collection_from_name("USGS/3DEP/1m"),
                         region = b),
               resampling = "bilinear")
}
\dontshow{\}) # examplesIf}
}
