% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_archaeology.R
\name{road_get_features}
\alias{road_get_features}
\title{Get feature assemblages from the ROAD database}
\usage{
road_get_features(
  continent = NULL,
  subcontinent = NULL,
  country = NULL,
  locality_type = NULL,
  cultural_period = NULL,
  technocomplex = NULL,
  category = NULL,
  age_min = NULL,
  age_max = NULL,
  feature_interpretation = NULL,
  assemblages = NULL
)
}
\arguments{
\item{continent}{specifies the continent(s) (e.g. Africa, Europe, Asia).
Run \code{road_list_argument_values("continent")} to display possible values.
The argument \code{continent} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{subcontinent}{specifies the continental region(s) (e.g. Southern Europe). 
Run \code{road_list_argument_values("subcontinent")} to display possible values.
The argument \code{subcontinent} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{country}{specifies the name of the country where a locality is situated 
(e.g. Germany, Kenya, Saudi Arabia). Run \code{road_list_argument_values("country")} 
to display possible values.
The argument \code{country} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{locality_type}{specifies the type of locality (e.g. cave, rockshelter, open air).
Run \code{road_list_argument_values("locality_type")} to display possible values.
The argument \code{locality_type} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{cultural_period}{specifies the main cultural epoch(s) and includes the 
Eurasian Paleolithic (Lower, Middle, Upper, Epi-) and the African Stone Age 
(Earlier, Middle, Later). Run \code{road_list_argument_values("cultural_period")} 
to display possible values. The argument \code{cultural_period} is a string 
(one item) or vector of strings (one or more items); defaults to NULL.}

\item{technocomplex}{specifies an archaeological culture or named stone tool 
industry (e.g. Oldowan, Acheulean, Mousterian).
Run \code{road_list_argument_values("technocomplex")} to display possible values.
The argument \code{technocomplex} is a string (one item) or vector of strings 
(one or more items); defaults to NULL.}

\item{category}{specifies the assemblage category with the classes 
human remains, raw material, typology, technology, function, organic tools, 
symbolic artifacts, feature, miscellaneous finds, paleofauna, animal remains, 
plant remains. The argument \code{category} is a string (one item) or 
vector of strings (one or more items); defaults to NULL.}

\item{age_min}{specifies the minimum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_min} will be converted to an integer; defaults to NULL.}

\item{age_max}{specifies the maximum age in years before present, using 1950 CE
as the baseline. If possible the argument \code{age_max} will be converted to an integer; defaults to NULL.}

\item{feature_interpretation}{specifies archaeological features present in 
the archaeological assemblage (e.g. bedding, burial, butchering event).
Run \code{road_list_argument_values("feature_interpretation")} to display 
possible values. The argument \code{feature_interpretation} is a string 
(one item) or vector of strings; defaults to NULL.}

\item{assemblages}{specifies a data frame necessarily containing columns 
locality_id, assemblage_id. It can be  generated as return value of the 
function 'road_get_assemblages'. It can be used instead of the locality 
and assemblage search parameters to filter the results.}
}
\value{
A data frame with information about archaeological features. Rows represent individual features, columns contain details on:

\code{interpretations}: Interpretation of the feature present in the 
archaeological assemblage. Interpretations can be "bedding", "burial", "butchering 
event", "combustion feature", "cupule", "dumping area".
}
\description{
The \strong{\code{road_get_features}} retrieves data on archaeological features from the ROAD database. Feature assemblages refer to archaeological features such as hearths, pits, or structures found at a site.
This function enables you to query feature data from the ROAD database using parameters like geographical location,
cultural periods, feature interpretation, and assemblages. Use the parameters to filter the results or omit them for broader results.
}
\examples{
\donttest{road_get_features(country = "Czech Republic", feature_interpretation = "textile imprints")}
\donttest{road_get_features(continent = "Africa", locality_type = c("cave"), 
                                         feature_interpretation = "bedding")}
}
