% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info.R
\name{road_summarize_archaeology}
\alias{road_summarize_archaeology}
\title{Get an overview of categorical values in the ROAD database}
\usage{
road_summarize_archaeology(term)
}
\arguments{
\item{term}{A string containing the search term (one item).}
}
\value{
Database search result as list.
}
\description{
The `road_summarize_archaeology` function provides a quick overview of the
presence of a given search term across archaeology-related tables/attributes 
in the ROAD database and archaeology-related \code{road_get_*} functions in \code{roadDB}.
It queries all relevant functions and returns a list indicating whether 
each function contains the search term. This helps you identify the appropriate 
\code{road_get_*} functions for your search.
Once identified, you can apply these functions to retrieve the relevant assemblages.
}
\details{
Background: The ROAD archaeology database is rich in categorical data, where 
archaeological findings are grouped according to their characteristics. These 
categories can be accessed using a variety of \code{road_get_*} functions, such as:

\itemize{
  \item \code{road_get_lithic_typologies()}
  \item \code{road_get_lithic_raw_materials()}
  \item \code{road_get_organic_tools()}
  \item \code{road_get_symbolic_artifacts()}
  \item \code{road_get_features()}
  \item \code{road_get_miscellaneous_finds()}
}

Some search terms may not be easily categorized, while others may appear 
across multiple categories depending on contextual interpretations. This 
function assists in identifying the most relevant categories for your search.
}
\examples{
\donttest{road_summarize_archaeology(term = "Cores")}
}
