% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_code.R
\name{generate_rmd_file}
\alias{generate_rmd_file}
\title{Generate Rmd file}
\usage{
generate_rmd_file(
  content,
  output_format = c("word", "pdf", "html", "word_document", "pdf_document",
    "html_document"),
  code = TRUE,
  ...
)
}
\arguments{
\item{content}{a string. The body of the Rmd file (for example code or text)}

\item{output_format}{a string representing the output format. The values
\code{"pdf"}, \code{"html"} or \code{"word"} and their knitr equivalent
\code{"pdf_document"}, \code{"html_document"} or \code{"word_document"} are
accepted.}

\item{code}{a boolean. Should the \code{content} string have to be inserted
in R chunk or is it just text? Default is TRUE (so the \code{content} will be
inserted in R chunk).}

\item{\dots}{other arguments passed to R chunk (for example
\code{eval = TRUE}, \code{echo = FALSE}...)}
}
\value{
a vector of characters representing an Rmd file (each element being
a line)
}
\description{
This function creates the Rmd file which will be rendered in a specific
format.
}
\details{
More information about the argument \dots in the  documentation of the
function \code{\link[rotulador]{render_code}}.
}
\examples{

generate_rmd_file(content = "Bonjour tout le monde",
                  code = FALSE,
                  output_format = "word")
generate_rmd_file(content = "print(AirPassengers)",
                  code = TRUE,
                  output_format = "pdf",
                  eval = TRUE,
                  echo = FALSE)
generate_rmd_file(content = "plot(AirPassengers)",
                  code = TRUE,
                  output_format = "html_document",
                  eval = FALSE,
                  echo = TRUE)

}
