% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{rrda.coef}
\alias{rrda.coef}
\title{Calculate the Bhat matrix from the return of the \code{rrda.fit} function.}
\usage{
rrda.coef(Bhat, nrank = NULL, lambda = NULL)
}
\arguments{
\item{Bhat}{A list of vectors of Bhat components, obtained by the \code{rrda.fit} function. If Bhat_mat is detected in Input, it selects the preferred matrix from the list of Bhat.}

\item{nrank}{A numeric vector specifying the ranks of Bhat. Default is \code{NULL}, which sets it to the ranks defined in the Bhat components.}

\item{lambda}{A numeric vector of ridge penalty values. Default is \code{NULL}, which sets it to the lambda values defined in the Bhat components.}
}
\value{
A list containing the Bhat matrix
}
\description{
This function calculates the coefficient Bhat (the coefficient of Ridge Redundancy Analysis for each parameter lambda and nrank) as a matrix form by using the Bhat components calculated by the rrda.fit function.
This function obtain the matrix form of Bhat as follows
\deqn{\hat{B}(\lambda, r) = FG^{\prime}}

Here, the Bhat components F and G are obtained from the \code{rrda.fit} function as follows

For \eqn{i = 1, \ldots, r}, the matrices \eqn{F} and \eqn{G} are defined as:
\deqn{F_{.i} = U_{\hat{B}(\lambda)}^{[i]}D_{\hat{B}(\lambda)}^{[i]}, \quad G_{.i} = V_{\hat{B}(\lambda)}^{[i]}}

If the input already contains Bhat as matrix form (Bhat_mat), the function selects the preferred matrix from the list of Bhat matrices.

The function can handle different ranks (nrank) and ridge penalty values (lambda) based on the input. If nrank or lambda is NULL, the function will use the values from the Bhat components. Note that if lambda = NULL and B matrix is large (nrow(B)*ncol(B) > 100000), the function is performed for the minimum lambda value only.
}
\examples{
set.seed(10)
simdata<-rdasim1(n = 100,p = 200,q = 200,k = 5)
X <- simdata$X
Y <- simdata$Y

Bhat <- rrda.fit(Y = Y, X = X, nrank = c(1:10))
Bhat_mat <- rrda.coef(Bhat = Bhat, nrank = 10)
}
