% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word.R
\name{word_to_md}
\alias{word_to_md}
\title{Convert a Word File to Markdown with Optional Embedded Images}
\usage{
word_to_md(
  docx_file,
  output_file = NULL,
  embed_images = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{docx_file}{Path to the input Word file.}

\item{output_file}{Path to the final Markdown output file. If null, the original file name.}

\item{embed_images}{Logical. If `TRUE`, all images will be embedded as Base64. Default is `FALSE`.}

\item{overwrite}{Logical. If `TRUE`, Output file is overwrote. Default is `FALSE`}
}
\value{
Saves a Markdown file (optionally with Base64-embedded images).
}
\description{
This function converts a Word (`.docx`) file to Markdown using Pandoc. Optionally, it embeds images as Base64 for a self-contained Markdown file.
}
\examples{
# Convert Word to Markdown without embedding images
\dontrun{
word_to_md("input.docx", "output.md", embed_images = FALSE)

# Convert and embed images as Base64
word_to_md("input.docx", "output_embedded.md", embed_images = TRUE)
}
}
