% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA_DCt.r
\name{ANOVA_DCt}
\alias{ANOVA_DCt}
\title{Relative expression (\eqn{\Delta Ct} method) analysis using ANOVA}
\usage{
ANOVA_DCt(x, numberOfrefGenes, block, alpha = 0.05, adjust = "none")
}
\arguments{
\item{x}{a data.frame structured as described in the vignette consisting of condition columns, target gene efficiency (E), target Gene Ct, reference 
gene efficiency and reference gene Ct values, respectively. Each Ct in the data frame is the mean of 
technical replicates. Complete amplification efficiencies of 2 was assumed in the example data for 
all wells but the calculated efficienies can be used instead.  \strong{NOTE:} Each line belongs to a separate 
individual reflecting a non-repeated measure experiment). See \href{../doc/vignette.html}{\code{vignette}}, 
section "data structure and column arrangement" for details.}

\item{numberOfrefGenes}{number of reference genes (1 or 2). Up to two reference genes can be handled.}

\item{block}{A string or NULL. If provided, this should be the name of the column in \code{x} that 
indicates the blocking factor. When qPCR is performed on different plates, variations between plates can introduce noise 
that obscures the true biological differences in gene expression. By using a blocking factor, 
each treatment and control group can be replicated across different plates, ensuring that 
at least one replicate of each condition is present on every plate.}

\item{alpha}{significance level for cld (default 0.05)}

\item{adjust}{p-value adjustment method passed to emmeans/cld}
}
\value{
A list with 4 elements:
\describe{
  \item{Final_data}{The row data plus weighed delta Ct (wDCt) values.}
  \item{lm}{The output of linear model analysis including ANOVA tables}
  \item{ANOVA}{ANOVA table based on CRD}
  \item{Result}{The result table including treatments and factors, RE (Relative Expression), LCL, UCL, 
  letter display for pair-wise comparisons and standard error with the lower and upper limits.}
}
}
\description{
Analysis of variance of relative expression (\eqn{\Delta Ct} method) values for 
all factor level combinations in which the expression level of a 
reference gene is used as normalizer.
}
\details{
The \code{ANOVA_DCt} function performs analysis of variance (ANOVA) of relative 
expression (RE) values for all factor level combinations using the expression 
level of reference gene(s) as a normalizer.
}
\examples{

# If the data include technical replicates, means of technical replicates
# should be calculated first using meanTech function.
# Applying ANOVA
ANOVA_DCt(data_3factor, numberOfrefGenes = 1, block = NULL)


ANOVA_DCt(data_2factorBlock, block = "Block", numberOfrefGenes = 1)


}
\references{
Livak, Kenneth J, and Thomas D Schmittgen. 2001. Analysis of
Relative Gene Expression Data Using Real-Time Quantitative PCR and the
Double Delta CT Method. Methods 25 (4). doi:10.1006/meth.2001.1262.

Ganger, MT, Dietz GD, and Ewing SJ. 2017. A common base method for analysis of qPCR data
and the application of simple blocking in qPCR experiments. BMC bioinformatics 18, 1-11.

Yuan, Joshua S, Ann Reed, Feng Chen, and Neal Stewart. 2006.
Statistical Analysis of Real-Time PCR Data. BMC Bioinformatics 7 (85). doi:10.1186/1471-2105-7-85.
}
\author{
Ghader Mirzaghaderi
}
