% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dbeta_rvec}
\alias{dbeta_rvec}
\alias{pbeta_rvec}
\alias{qbeta_rvec}
\alias{rbeta_rvec}
\title{Beta Distribution, Using Multiple Draws}
\usage{
dbeta_rvec(x, shape1, shape2, ncp = 0, log = FALSE)

pbeta_rvec(q, shape1, shape2, ncp = 0, lower.tail = TRUE, log.p = FALSE)

qbeta_rvec(p, shape1, shape2, ncp = 0, lower.tail = TRUE, log.p = FALSE)

rbeta_rvec(n, shape1, shape2, ncp = 0, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{shape1, shape2}{Parameters
for beta distribution. Non-negative.
See \code{\link[=dbeta]{dbeta()}}. Can be an rvec.}

\item{ncp}{Non-centrality parameter.
Default is \code{0}. Cannot be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}; otherwise an ordinary R vector.
}
}
\description{
Density, distribution function,
quantile function and random generation for the
Beta distribution, modified to work with
rvecs.
}
\details{
Functions \code{dbeta_rvec()}, \code{pbeta_rvec()},
\code{pbeta_rvec()} and \code{rbeta_rvec()} work like
base R functions \code{\link[=dbeta]{dbeta()}}, \code{\link[=pbeta]{pbeta()}},
\code{\link[=qbeta]{qbeta()}}, and \code{\link[=rbeta]{rbeta()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rbeta_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{dbeta_rvec()}, \code{pbeta_rvec()},
\code{pbeta_rvec()} and \code{rbeta_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\examples{
x <- rvec(list(c(0, 0.25),
               c(0.5, 0.99)))
dbeta_rvec(x, shape1 = 1, shape2 = 1)
pbeta_rvec(x, shape1 = 1, shape2 = 1)

rbeta_rvec(n = 2,
           shape = 1:2,
           shape2 = 1,
           n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dbeta]{dbeta()}}, \code{\link[=pbeta]{pbeta()}}, \code{\link[=qbeta]{qbeta()}}, \code{\link[=rbeta]{rbeta()}} Base R equivalents
\item \link[stats:Distributions]{distributions} All base R distributions
}
}
