% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crowd_plots_as_tabset.R
\name{crowd_plots_as_tabset}
\alias{crowd_plots_as_tabset}
\title{Convert List of Plots to Quarto Tabset}
\usage{
crowd_plots_as_tabset(
  plot_list,
  plot_type = c("cat_plot_html", "int_plot_html", "auto"),
  save = FALSE,
  fig_height = NULL,
  fig_height_int_default = 6
)
}
\arguments{
\item{plot_list}{A named list of ggplot2 objects. Names become tab labels.
Typically created with \code{makeme(crowd = c("target", "others"))}.}

\item{plot_type}{Character. Type of plots in the list. One of:
\itemize{
\item \code{"cat_plot_html"} (default): Categorical horizontal bar charts
\item \code{"int_plot_html"}: Interval plots (violin/box plots)
\item \code{"auto"}: Auto-detect from first non-NULL plot's data structure
}}

\item{save}{Logical. If \code{TRUE} (default), generates download links for plot
data and images via \code{\link[=get_fig_title_suffix_from_ggplot]{get_fig_title_suffix_from_ggplot()}}.}

\item{fig_height}{Numeric or NULL. Manual figure height override in inches.
If \code{NULL} (default), height is calculated automatically based on \code{plot_type}.}

\item{fig_height_int_default}{Numeric. Default height for interval plots when
auto-calculation is not available (default: 6 inches).}
}
\value{
Invisibly returns \code{NULL}. The function's purpose is its side effect
of printing Quarto markdown that creates a tabset.
}
\description{
Creates a Quarto tabset from a named list of ggplot2 objects, typically
generated by \code{\link[=makeme]{makeme()}} with \code{crowd} parameter. Each plot becomes a tab
with automatic height calculation and optional download links.
}
\details{
This function is designed to be called within a Quarto document code chunk.
It generates markdown that creates a tabset where each non-NULL plot in
\code{plot_list} appears as a separate tab.

\strong{Height Calculation:}
\itemize{
\item For \code{"cat_plot_html"}: Uses \code{\link[=fig_height_h_barchart2]{fig_height_h_barchart2()}} which accounts for
number of variables, categories, and label lengths
\item For \code{"int_plot_html"}: Uses \code{fig_height_int_default} (simpler plots need
less sophisticated calculation)
\item For \code{"auto"}: Detects type by checking for \code{.category} column (categorical)
vs numeric statistics columns (interval)
}

\strong{Requirements:}
\itemize{
\item Must be run within knitr/Quarto context
\item Plots should be created with \code{\link[=makeme]{makeme()}}
\item Plot list should have meaningful names for tab labels
}
}
\examples{
\dontrun{
# In a Quarto document
plots <- makeme(
  data = ex_survey,
  dep = b_1:b_3,
  crowd = c("target", "others"),
  mesos_var = "f_uni",
  mesos_group = "Uni of A"
)

# Create tabset with auto-detection
crowd_plots_as_tabset(plots)

# Create tabset for interval plots
int_plots <- makeme(
  data = ex_survey,
  dep = c_1:c_2,
  indep = x1_sex,
  type = "int_plot_html",
  crowd = c("target", "others"),
  mesos_var = "f_uni",
  mesos_group = "Uni of A"
)
crowd_plots_as_tabset(int_plots, plot_type = "int_plot_html")

# Without download links
crowd_plots_as_tabset(plots, save = FALSE)

# With manual height override
crowd_plots_as_tabset(plots, fig_height = 8)
}
}
\seealso{
\itemize{
\item \code{\link[=makeme]{makeme()}} for creating plots with crowd parameter
\item \code{\link[=fig_height_h_barchart2]{fig_height_h_barchart2()}} for categorical plot height calculation
\item \code{\link[=get_fig_title_suffix_from_ggplot]{get_fig_title_suffix_from_ggplot()}} for caption generation
\item \code{\link[=girafe]{girafe()}} for interactive plot rendering
}
}
