% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_burn_probability.R
\name{flp20_to_df}
\alias{flp20_to_df}
\title{Convert FLP20 file to a data frame}
\usage{
flp20_to_df(file)
}
\arguments{
\item{file}{A character string specifying the path to the FLP20 .csv file.}
}
\value{
A data frame with reshaped data, including `name` (original FIL column index)
   and `FL` (calculated flame length).
}
\description{
Reads a .csv file, typically an FLP20 output from FConstMTT, for single fire event simulation,
and reshapes the data to long format, calculating flame length (FL) from `FIL` columns.
`PBurn` is expected to be 1 for individual fires, and `FIL` columns are binary (1 or 0).
}
\examples{
\dontrun{
# Process an FLP20 file
df_result <- flp20_to_df("path/to/your/file.csv")
}
}
