% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_scholid.R
\name{extract_scholid}
\alias{extract_scholid}
\title{Extract scholarly identifiers from text}
\usage{
extract_scholid(text, type)
}
\arguments{
\item{text}{A character vector of text.}

\item{type}{A single string giving the identifier type. See
\code{scholid_types()} for supported values.}
}
\value{
A list of character vectors of extracted identifiers.
}
\description{
Extract identifiers of a single supported type from free text.

The result is a list with one element per input element. Each element is a
character vector of matches (possibly length 0). \code{NA} inputs yield an empty
character vector.

Matches are returned as found in the text; use \code{normalize_scholid()} to
convert identifiers to canonical form.
}
\examples{
extract_scholid("See https://doi.org/10.1000/182.", "doi")
extract_scholid("ORCID 0000-0002-1825-0097", "orcid")

}
