% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdftest-functions.R
\name{sdf.test}
\alias{sdf.test}
\title{SDF Test}
\usage{
sdf.test(
  X1,
  X2,
  Te,
  alpha,
  q1 = 4,
  method1 = "GCV",
  f1_true = NULL,
  q2 = q1,
  method2 = method1,
  f2_true = f1_true,
  N = 10000,
  cores = 1,
  nulldistr = NULL
)
}
\arguments{
\item{X1}{Longest time series.}

\item{X2}{Shortest time series.}

\item{Te}{Integer. Number of bins.}

\item{alpha}{Numeric. Significance level for the test.}

\item{q1}{Integer. Penalisation order for \code{X1},
\code{q=1,2,3,4,5,6} are available (default \code{4}).}

\item{method1}{Character. Method for selecting the smoothing parameter for
\code{X1} (default "\code{GCV}").}

\item{f1_true}{Vector or \code{NULL}. True regression function evaluated at
equi-spaced points. Required only if \code{method1} is set
to "\code{GCV-oracle}" or "\code{ML-oracle}".}

\item{q2}{Integer. Penalization order for \code{X2} (default
\code{q1}).}

\item{method2}{Character. Method for selecting the smoothing parameter for
\code{X2} (default \code{method1}).}

\item{f2_true}{Vector or \code{NULL}. True regression function evaluated at
equi-spaced points. Required only if \code{method2} is set
to "\code{GCV-oracle}" or "\code{ML-oracle}" (default
\code{f1_true}).}

\item{N}{Integer. Number of iterations for null distribution computa-
tion (default \code{10000}).}

\item{cores}{Integer. Number of cores for parallel computation of null
distribution (default \code{1}).}

\item{nulldistr}{Vector or \code{NULL}. Vector of empirical null distribution
(default \code{NULL}).}
}
\value{
An object of class \code{"test"}, which is a list containing the
following components:
\itemize{
\item \code{result}: Logical. \code{TRUE} if the null hypothesis of
equality of spectral densities is accepted by the test,
\code{FALSE} otherwise.
\item \code{S}: Value of the statistic.
\item \code{quantile}: Empirical quantile used for the test.
\item \code{p-value}: p-value of the test according to the
empirical null distribution.
\item \code{nulldistr}: Vector of empirical null distribution.
}
}
\description{
Performs the test for equality of spectral densities of two time series.
}
\examples{
# --- Example 1: Using random data ---
test <- sdf.test(
  X1 = rnorm(100), X2 = rnorm(80),
  q1 = 4, method1 = "GCV", Te = 20, alpha = 0.05, N = 1000
)
test

# --- Example 2: Using random data ---
\donttest{
X1 <- arima.sim(list(order=c(1,0,0),ar=0.5),n = 1200,rand.gen = rnorm, sd = 1)
X2 <- arima.sim(list(order=c(1,0,0),ar=0.8),n = 1000,rand.gen = rnorm, sd = 1)
sdf.test(
  X1 = X1, X2 = X2,
  q1 = 4, method1 = "GCV", Te = 176, alpha = 0.05
)
}

# --- Example 3: Using EEG dataset ---
\donttest{
data(eeg_data)
X1 <- subset(eeg_data, condition == "first_frontal_tDCS")$signal
X2 <- subset(eeg_data, condition == "second_frontal_tDCS")$signal
test <- sdf.test(
  X1 = X1, X2 = X2,
  q1 = 4, method1 = "ML", Te = 2100, alpha = 0.05, cores = 50
)
test
}

}
\references{
Nadin, Krivobokova, Enikeeva (2026). Nonparametric two sample test of
spectral densities.
\url{https://arxiv.org/abs/2602.10774}
}
