################################################################################
# --------------------------- smoothpar_selection ---------------------------- #
################################################################################

test_that("smoothpar_selection calls GCV.opt for method = 'GCV'", {
  
  mock_GCV <- function(y, q, evals) {
    expect_equal(y, c(1, 2, 3))
    expect_equal(q, 3)
    return(0.111)
  }
  
  local_mocked_bindings(GCV.opt = mock_GCV)
  
  out <- smoothpar_selection(
    y = c(1, 2, 3),
    q = 3,
    evals = rep(1, 5),
    method = "GCV"
  )
  
  expect_equal(out, 0.111)
})

test_that("smoothpar_selection calls ML.opt for method = 'ML'", {
  
  mock_ML <- function(y, q, evals) {
    expect_equal(y, c(1, 2))
    expect_equal(q, 5)
    return(0.222)
  }
  
  local_mocked_bindings(ML.opt = mock_ML)
  
  out <- smoothpar_selection(
    y = c(1, 2),
    q = 5,
    evals = rep(1, 4),
    method = "ML"
  )
  
  expect_equal(out, 0.222)
})

test_that("GCV-oracle errors if f.true is missing", {
  
  expect_error(
    smoothpar_selection(
      y = 1:5,
      q = 2,
      evals = rep(1, 5),
      method = "GCV-oracle",
      f.true = NULL,
      sigma = 1
    ),
    "True spectral density is missing.",
    fixed = TRUE
  )
})

test_that("GCV-oracle errors if sigma is missing", {
  
  expect_error(
    smoothpar_selection(
      y = 1:5,
      q = 2,
      evals = rep(1, 5),
      method = "GCV-oracle",
      f.true = 1:5,
      sigma = NULL
    ),
    "True variance is missing.",
    fixed = TRUE
  )
})

test_that("GCV-oracle calls GCV.opt with oracle arguments", {
  
  mock_check <- function(x) {
    invisible(TRUE)
  }
  
  mock_VST <- function(x, m) {
    expect_equal(m, 1)
    expect_equal(x, c(2, 3, 4, 5, 4, 3, 2, 1))
    return(log(x)) 
  }
  
  mock_GCV <- function(y, q, evals, oracle, f.true, sigma) {
    expect_null(y)
    expect_true(oracle)
    expect_equal(q, 3)
    expect_equal(sigma, 0.5)
    expect_equal(f.true, log(c(2, 3, 4, 5, 4, 3, 2, 1)))
    return(0.333)
  }
  
  local_mocked_bindings(
    VST = mock_VST,
    GCV.opt = mock_GCV,
    check_numeric_vector = mock_check
  )
  
  out <- smoothpar_selection(
    y = 1:10,
    q = 3,
    evals = rep(1, 9),
    method = "GCV-oracle",
    f.true = c(1, 2, 3, 4, 5),
    sigma = 0.5
  )
  
  expect_equal(out, 0.333)
})