% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_congruence.R
\name{congruence_test}
\alias{congruence_test}
\title{SEMinR function to bootstrap calculate the congruence coefficient}
\usage{
congruence_test(
  seminr_model,
  nboot = 2000,
  seed = 123,
  alpha = 0.05,
  threshold = 1
)
}
\arguments{
\item{seminr_model}{The SEMinR model for CVPAT analysis}

\item{nboot}{The number of bootstrap subsamples to execute (defaults to 2000).}

\item{seed}{The seed for reproducibility (defaults to 123).}

\item{alpha}{The required level of alpha for statistical testing (defaults
to 0.05).}

\item{threshold}{The threshold with which to compare significance testing
H0: rc < 1 (defaults to 1).}
}
\value{
A matrix of the estimated congruence coefficient and results of
significance testing.
}
\description{
`congruence_test` conducts a single bootstrapped congruence test.
}
\examples{
# Load libraries
library(seminr)
library(seminrExtras)

# Create measurement model ----
corp_rep_mm <- constructs(
  composite("QUAL", multi_items("qual_", 1:8), weights = mode_B),
  composite("PERF", multi_items("perf_", 1:5), weights = mode_B),
  composite("CSOR", multi_items("csor_", 1:5), weights = mode_B),
  composite("ATTR", multi_items("attr_", 1:3), weights = mode_B),
  composite("COMP", multi_items("comp_", 1:3)),
  composite("LIKE", multi_items("like_", 1:3))
)

# Create structural model ----
corp_rep_sm <- relationships(
  paths(from = c("QUAL", "PERF", "CSOR", "ATTR"), to = c("COMP", "LIKE"))
)

# Estimate the model ----
corp_rep_pls_model <- estimate_pls(
  data = corp_rep_data,
  measurement_model = corp_rep_mm,
  structural_model  = corp_rep_sm,
  missing = mean_replacement,
 missing_value = "-99")

# Assess the base model ----
congruence_test(seminr_model = corp_rep_pls_model,
                nboot = 20,
                seed = 123,
                alpha = 0.05,
                threshold = 1)

}
\references{
Franke, G. R., Sarstedt, M., & Danks, N. P. (2021). Assessing
measure congruence in nomological networks. Journal of Business Research,
130, 318-334.
}
