% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_app_tag.R
\name{st_app_tag}
\alias{st_app_tag}
\title{Fetch Apps by Custom Fields and Tags}
\usage{
st_app_tag(
  app_id_type,
  custom_fields_filter_id,
  name = NULL,
  value = NULL,
  global = TRUE,
  last_known_id = NULL,
  auth_token = NULL,
  base_url = "https://api.sensortower.com"
)
}
\arguments{
\item{app_id_type}{Character string. Operating System. Must be one of
"itunes" (iOS) or "unified". Required.}

\item{custom_fields_filter_id}{Character string. ID of a Sensor Tower
custom field filter. Required. Use the filter ID from relevant endpoint.}

\item{name}{Optional. Character string. Name of Custom or Global Field.
Defaults to "Stock Ticker".}

\item{value}{Optional. Character string. Tag value for custom or global 
field provided. Leave blank to fetch all possible apps.}

\item{global}{Optional. Logical. Filter by global or organization custom 
fields. Defaults to TRUE (false means organization custom fields).}

\item{last_known_id}{Optional. Character string. Supply last_known_id from 
previous request to get next page. Leave blank to get first page.}

\item{auth_token}{Optional. Character string. Your Sensor Tower API token.}

\item{base_url}{Optional. Character string. The base URL for the API.}
}
\value{
A [tibble][tibble::tibble] with app data including IDs and metadata.
}
\description{
Retrieves apps filtered by custom fields and tags from Sensor Tower.
This function uses the /v1/app_tag/apps endpoint.
}
