% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{get_input_labels}
\alias{get_input_labels}
\title{Retrieve the Labels of Input Objects}
\usage{
get_input_labels(x, ...)
}
\arguments{
\item{x}{An object for which to retrieve input labels; typically a data.frame.}

\item{...}{Passed onto methods.}
}
\value{
A character vector of input labels
}
\description{
Returns the labels of the \pkg{shiny} inputs for the provided object.
}
\examples{
df <- data.frame(
  name = c("Alice", "Bob"),
  age = c(25, 30),
  completed = c(TRUE, FALSE)
)

get_input_labels(df)
}
