% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_functions.R
\name{eval_pred_dens}
\alias{eval_pred_dens}
\title{Evaluate Predictive Densities}
\usage{
eval_pred_dens(x, mod, data_test, nsamp = 100, log = FALSE)
}
\arguments{
\item{x}{Numeric vector of points for which the predictive density is to be evaluated.}

\item{mod}{A \code{shrinkGPR} object representing the fitted Gaussian process regression model.}

\item{data_test}{Data frame with one row containing the covariates for the test set.
Variables in \code{data_test} must match those used in model fitting.}

\item{nsamp}{Positive integer specifying the number of posterior samples to use for the evaluation. Default is 100.}

\item{log}{Logical; if \code{TRUE}, returns the log predictive density. Default is \code{FALSE}.}
}
\value{
A numeric vector containing the predictive densities (or log predictive densities) for the points in \code{x}.
}
\description{
\code{eval_pred_dens} evaluates the predictive density for a set of points based on a fitted \code{shrinkGPR} model.
}
\details{
This function computes predictive densities by marginalizing over posterior samples drawn from the fitted model. If the mean equation is included in the model, the corresponding covariates are incorporated.
}
\examples{
\donttest{
if (torch::torch_is_installed()) {
  # Simulate data
  set.seed(123)
  torch::torch_manual_seed(123)
  n <- 100
  x <- matrix(runif(n * 2), n, 2)
  y <- sin(2 * pi * x[, 1]) + rnorm(n, sd = 0.1)
  data <- data.frame(y = y, x1 = x[, 1], x2 = x[, 2])

  # Fit GPR model
  res <- shrinkGPR(y ~ x1 + x2, data = data)

  # Create point at which to evaluate predictive density
  data_test <- data.frame(x1 = 0.8, x2 = 0.5)
  eval_points <- c(-1.2, -1, 0)

  eval_pred_dens(eval_points, res, data_test)

  # Is vectorized, can also be used in functions like curve
  curve(eval_pred_dens(x, res, data_test), from = -1.5, to = -0.5)
  abline(v = sin(2 * pi * 0.8), col = "red")
  }
}
}
