% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simEventData.R
\name{simEventData}
\alias{simEventData}
\title{Simulate Event Data with Multiple Event Types and Covariates}
\usage{
simEventData(
  N,
  beta = NULL,
  eta = NULL,
  nu = NULL,
  at_risk = NULL,
  term_deltas = c(0, 1),
  max_cens = Inf,
  add_cov = NULL,
  override_beta = NULL,
  max_events = 10,
  lower = 10^(-15),
  upper = 200,
  gen_A0 = NULL,
  at_risk_cov = NULL,
  ...
)
}
\arguments{
\item{N}{Integer. Number of individuals to simulate.}

\item{beta}{Numeric matrix. Regression coefficients matrix where columns correspond to event types (N0, N1, ...) and rows correspond to covariates (L0, A0, L1, L2, ...) and event counts (N0, N1, ...). Default is a zero matrix.}

\item{eta}{Numeric vector. Shape parameters of the Weibull baseline intensity for each event type. Default is 0.1 for all events.}

\item{nu}{Numeric vector. Scale parameters of the Weibull baseline intensity for each event type. Default is 1.1 for all events.}

\item{at_risk}{Function. Function determining if an individual is at risk for each event type, given their current event counts. Takes a numeric vector events and returns a binary vector. Default returns 1 for all events.}

\item{term_deltas}{Integer vector. Event types considered terminal (after which no further events occur). Default is c(0, 1).}

\item{max_cens}{Numeric. Maximum censoring time. Events occurring after this time are censored. Default is Inf (no maximal censoring).}

\item{add_cov}{Named list of functions. Functions generating additional baseline covariates. Each function takes integer N and returns a numeric vector of length N. Default is NULL.}

\item{override_beta}{Named list. Used to specify entries of the \code{beta} matrix to override defaults. For example, \code{list("L0" = c("N1" = 2))} sets the effect of L0 on N1 to 2.}

\item{max_events}{Integer. Maximum number of events to simulate per individual. Default is 10.}

\item{lower}{Numeric. Lower bound for root-finding in inverse cumulative hazard calculations. Default is \eqn{10^{-15}}.}

\item{upper}{Numeric. Upper bound for root-finding in inverse cumulative hazard calculations. Default is 200.}

\item{gen_A0}{Function. Function to generate the baseline treatment covariate A0. Takes N and L0 as inputs. Default is a Bernoulli(0.5) random variable.}

\item{at_risk_cov}{Function. Function determining if an individual is at risk for each event type, given their covariates. Takes a numeric vector covariates and returns a binary vector. Default returns 1 for all events.}

\item{...}{Additional technical arguments}
}
\value{
A \code{data.table} with columns:
\item{ID}{Individual identifier}
\item{Time}{Time of event}
\item{Delta}{Event type at time}
\item{L0}{Baseline covariate}
\item{A0}{Baseline treatment}
\item{L1, L2, ...}{Additional baseline covariates if specified}
\item{N0, N1, ...}{Event counts up to the current event}
}
\description{
Simulate Continuous Time-to-Event Data with Multiple Event Types
}
\details{
\code{simEventData} simulates event times and types for a cohort of individuals in a
counting process framework. It supports multiple event types (by default 4),
including terminal events, with intensities influenced by baseline covariates
and previous event history.

The event intensities for event type \eqn{x} at time \eqn{t} are given by
\deqn{
\lambda^x(t) = \lambda_0^x(t) \exp(\beta_x^T L),
}
where the baseline intensity follows a Weibull hazard function:
\deqn{
\lambda_0^x(t) = \eta^x \nu^x t^{\nu^x - 1}.
}
Here, \eqn{L} is the vector of covariates and event counts, and \eqn{\beta^x} is the
a vector of coefficients representing the effect of covariates and previous events on the intensity.
}
\examples{
# Simulate data for 10 individuals with default settings
sim_data <- simEventData(N = 10)
head(sim_data)

}
