% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_imputation.R
\name{impute_mean_window}
\alias{impute_mean_window}
\title{Remove NA using weighted moving average}
\usage{
impute_mean_window(data = NULL, k = 2, weighting = "simple")
}
\arguments{
\item{data}{A time series vector or matrix}

\item{k}{A integer width of the moving average window. Expands
to both sides of the center element e.g. k = 2 means 4
observations (2 left, 2 right) are taken into account.
If all observations in the current window are NA, the
window size is automatically increased until there are
at least 2 non-NA values present}

\item{weighting}{A string with the weighting strategy to be used. More
details below (default is "simple").}
}
\value{
A set of filtered time series using
                      the imputation function.
}
\description{
Remove NA using weighted moving average
}
\note{
The \code{weighting} parameter defines the weighting strategy used
in the moving window. The strategies available are:

\itemize{
\item{\code{simple} - Simple Moving Average (SMA) (default option)}
\item{\code{linear} - Linear Weighted Moving Average (LWMA)}
\item{\code{exponential} - Exponential Weighted Moving Average (EWMA)}
}
}
\references{
The implementation of this function was adapted from the \code{imputeTS} R
Package. The code is open-source, under the GPL license, and is available on
GitHub \url{https://github.com/SteffenMoritz/imputeTS}.
}
\author{
Felipe Carlos, \email{efelipecarlos@gmail.com}
}
