% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.slasso}
\alias{plot.slasso}
\alias{plot.slasso_cv}
\title{Plot the results of  the S-LASSO method}
\usage{
\method{plot}{slasso_cv}(x, ...)

\method{plot}{slasso}(x, ...)
}
\arguments{
\item{x}{The output of  either \code{slasso.fr_cv} or \code{slasso.fr}.}

\item{...}{No additional parameters, called for side effects.}
}
\value{
No return value, called for side effects.
}
\description{
This function provides plots of the S-LASSO coefficient function estimate when applied to the output of \code{slasso.fr}, whereas
provides the cross-validation plots when applied to the output of \code{slasso.fr_cv}. In the latter case the first plot displays the CV values as a function of  \code{lambda_L}, \code{lambda_s} and \code{lambda_t}, and
the second plot displays the CV values as a function of \code{lambda_L} with \code{lambda_s} and \code{lambda_t} fixed at their optimal values.
}
\examples{
library(slasso)
data<-simulate_data("Scenario II",n_obs=150)
X_fd=data$X_fd
Y_fd=data$Y_fd
domain=c(0,1)
n_basis_s<-30
n_basis_t<-30
breaks_s<-seq(0,1,length.out = (n_basis_s-2))
breaks_t<-seq(0,1,length.out = (n_basis_t-2))
basis_s <- fda::create.bspline.basis(domain,breaks=breaks_s)
basis_t <- fda::create.bspline.basis(domain,breaks=breaks_t)
mod_slasso<-slasso.fr(Y_fd = Y_fd,X_fd=X_fd,basis_s=basis_s,basis_t=basis_t,
lambda_L = -1.5,lambda_s =-8,lambda_t = -7,B0 =NULL,invisible=1,max_iterations=10)
plot(mod_slasso)
}
