% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{reproject}
\alias{reproject}
\title{Reproject coordinates between coordinate systems}
\usage{
reproject(
  from,
  to,
  x = NULL,
  y = NULL,
  coords = NULL,
  model = NULL,
  add = FALSE,
  input_prefix = "",
  output_prefix = "new"
)
}
\arguments{
\item{from, to}{Either a CRS code accepted by GDAL, a valid integer
EPSG value, an object of class \code{crs}, the value "raster"
(converting from/to pixel coordinates), or "world" (converting
from/to whatever CRS is set for the underlying map)}

\item{x, y}{Coordinates in two dimensions (if missing, coordinates
are expected to be in the \code{data.frame} specified in the
\code{coords} parameter as columns "x" and "y")}

\item{coords}{data.frame-like object with coordinates in columns
"x" and "y"}

\item{model}{Object of the class \code{slendr_model}}

\item{add}{Add column coordinates to the input data.frame
\code{coords} (coordinates otherwise returned as a separate
object)?}

\item{input_prefix, output_prefix}{Input and output prefixes of data
frame columns with spatial coordinates}
}
\value{
Data.frame with converted two-dimensional coordinates given as input
}
\description{
Converts between coordinates on a compiled raster map (i.e. pixel
units) and different Geographic Coordinate Systems (CRS).
}
\examples{
lon_lat_df <- data.frame(x = c(30, 0, 15), y = c(60, 40, 10))

reproject(
  from = "epsg:4326",
  to = "epsg:3035",
  coords = lon_lat_df,
  add = TRUE # add converted [lon,lat] coordinates as a new column
)
}
