% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.R
\name{sf_to_spm}
\alias{sf_to_spm}
\alias{single_sf_to_spm}
\title{single \code{sf} to \code{spm}}
\usage{
single_sf_to_spm(
  sf_obj,
  n_pts,
  type = "regular",
  by_polygon = FALSE,
  poly_ids = NULL,
  var_ids = NULL
)

sf_to_spm(
  sf_obj,
  n_pts,
  type = "regular",
  by_polygon = FALSE,
  poly_ids = NULL,
  var_ids = NULL
)
}
\arguments{
\item{sf_obj}{a \code{sf} object s.t. its geometries are polygons.}

\item{n_pts}{a \code{numeric} scalar representing the number of points to
create a grid in the study region on which the polygons in \code{sf_obj}
is observed. Alternatively, it can be a vector of the same length as
\code{nrow(sf_obj)}. In this case, it generates the given number of
points for each polygon in \code{sf_obj}.}

\item{type}{a \code{character} indicating the type of grid to be
generated. The options are \code{c("random", "regular",
    "hexagonal")}. For more details, see \code{st_sample} in the \code{sf}
package.}

\item{by_polygon}{a \code{logical} indicating whether we should generate
\code{n_pts} by polygon or for the \code{n_pts} for the whole study
region.}

\item{poly_ids}{a \code{character} vector informing the name of the variable
in \code{sf_obj} that represents the polygons unique identifiers. In
case this is not informed, we assume the id of the polygons are given by
their row numbers.}

\item{var_ids}{a scalar or vector of type \code{character} indicating the
(numerical) variables that are going to be analyzed.}
}
\value{
a named \code{list} of size 6 belonging to the class
\code{spm}. This list stores all the objects necessary to fit models
using the \code{\link{fit_spm}}.
}
\description{
Transforming a \code{sf} into a \code{spm} object (Internal use)
}
\examples{
data(liv_lsoa) # loading the LSOA data

msoa_spm <- sf_to_spm(sf_obj = liv_msoa, n_pts = 1000,
                      type = "regular", by_polygon = FALSE,
                      poly_ids = "msoa11cd",
                      var_ids = "leb_est")
}
