% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridge.summary.R
\name{ridge.summary}
\alias{ridge.summary}
\title{Format Ridge Model Output as LaTeX Tables}
\usage{
ridge.summary(x, ..., include.cv.trace = TRUE, latex = TRUE)
}
\arguments{
\item{x}{A ridge model object returned by \code{\link{ridge.regression}()} (class \code{"ridge.model"}).}

\item{...}{Further arguments passed to or from methods (unused).}

\item{include.cv.trace}{Logical. Whether to include cross-validation trace information. Default is \code{TRUE}.}

\item{latex}{Logical; if \code{TRUE} (default), returns LaTeX-formatted tables using \code{kableExtra}.
If \code{FALSE}, prints plain-text summary tables to the console.}
}
\value{
If \code{latex = TRUE}, returns a \code{knitr::asis_output} object (LaTeX code) for PDF rendering.
        If \code{latex = FALSE}, prints formatted summary tables to the console and returns the underlying data frames.
}
\description{
Formats and displays ridge regression model output from \code{ridge.regression()}
as LaTeX tables for PDF rendering or plain text for console viewing.
}
\examples{
# Load example data
data(mtcars)

# Fit ridge regression model
ridge.fit <- ridge.regression(mpg ~ wt + hp + disp, data = mtcars)

# Print a LaTeX-formatted summary
ridge.summary(ridge.fit, include.cv.trace = FALSE)

# Print a plain-text summary
ridge.summary(ridge.fit, include.cv.trace = FALSE, latex = FALSE)
}
