% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Patch_Morph.R
\name{plot_raster_by_name}
\alias{plot_raster_by_name}
\title{Plot a raster by its name}
\usage{
plot_raster_by_name(rasters, raster_name)
}
\arguments{
\item{rasters}{list A list of rasters.}

\item{raster_name}{character The name of the raster to be plotted.}
}
\value{
NULL This function does not return a value. It plots the raster if found.
}
\description{
\code{plot_raster_by_name} plots a raster from a list of rasters based on the provided raster name.
}
\examples{
\donttest{
# Define input parameters
las <- lidR::readLAS(system.file("extdata", "MixedConifer.laz", package="lidR"))
input_raster <- lidR::rasterize_canopy(las, res = 1, lidR::pitfree(c(0,2,5,10,15), c(0, 2)))
suitList <- c(0, 2, 32)
gapList <- seq(1, 8, by = 1)
spurList <- seq(1, 8, by = 1)

# Process the rasters
processed_rasters <- process_rasters_patchmorph(input_raster, suitList, gapList, spurList)

# Plot a raster by its name
plot_raster_by_name(processed_rasters, "suit_2_gap_2_spur_6")
}

}
