% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_feature_robust_scaler.R
\name{ft_robust_scaler}
\alias{ft_robust_scaler}
\title{Feature Transformation -- RobustScaler (Estimator)}
\usage{
ft_robust_scaler(
  x,
  input_col = NULL,
  output_col = NULL,
  lower = 0.25,
  upper = 0.75,
  with_centering = TRUE,
  with_scaling = TRUE,
  relative_error = 0.001,
  uid = random_string("ft_robust_scaler_"),
  ...
)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{input_col}{The name of the input column.}

\item{output_col}{The name of the output column.}

\item{lower}{Lower quantile to calculate quantile range.}

\item{upper}{Upper quantile to calculate quantile range.}

\item{with_centering}{Whether to center data with median.}

\item{with_scaling}{Whether to scale the data to quantile range.}

\item{relative_error}{The target relative error for quantile computation.}

\item{uid}{A character string used to uniquely identify the feature transformer.}

\item{...}{Optional arguments; currently unused.}
}
\value{
The object returned depends on the class of \code{x}. If it is a
\code{spark_connection}, the function returns a \code{ml_estimator} or a
\code{ml_estimator} object. If it is a \code{ml_pipeline}, it will return
a pipeline with the transformer or estimator appended to it. If a
\code{tbl_spark}, it will return a \code{tbl_spark} with the transformation
 applied to it.
}
\description{
RobustScaler removes the median and scales the data according to the quantile range.
The quantile range is by default IQR (Interquartile Range, quantile range between the
1st quartile = 25th quantile and the 3rd quartile = 75th quantile) but can be configured.
Centering and scaling happen independently on each feature by computing the relevant
statistics on the samples in the training set. Median and quantile range are then
stored to be used on later data using the transform method.
Note that missing values are ignored in the computation of medians and ranges.
}
\details{
In the case where \code{x} is a \code{tbl_spark}, the estimator
fits against \code{x} to obtain a transformer, returning a \code{tbl_spark}.
}
\seealso{
Other feature transformers: 
\code{\link{ft_binarizer}()},
\code{\link{ft_bucketizer}()},
\code{\link{ft_chisq_selector}()},
\code{\link{ft_count_vectorizer}()},
\code{\link{ft_dct}()},
\code{\link{ft_elementwise_product}()},
\code{\link{ft_feature_hasher}()},
\code{\link{ft_hashing_tf}()},
\code{\link{ft_idf}()},
\code{\link{ft_imputer}()},
\code{\link{ft_index_to_string}()},
\code{\link{ft_interaction}()},
\code{\link{ft_lsh}},
\code{\link{ft_max_abs_scaler}()},
\code{\link{ft_min_max_scaler}()},
\code{\link{ft_ngram}()},
\code{\link{ft_normalizer}()},
\code{\link{ft_one_hot_encoder}()},
\code{\link{ft_one_hot_encoder_estimator}()},
\code{\link{ft_pca}()},
\code{\link{ft_polynomial_expansion}()},
\code{\link{ft_quantile_discretizer}()},
\code{\link{ft_r_formula}()},
\code{\link{ft_regex_tokenizer}()},
\code{\link{ft_sql_transformer}()},
\code{\link{ft_standard_scaler}()},
\code{\link{ft_stop_words_remover}()},
\code{\link{ft_string_indexer}()},
\code{\link{ft_tokenizer}()},
\code{\link{ft_vector_assembler}()},
\code{\link{ft_vector_indexer}()},
\code{\link{ft_vector_slicer}()},
\code{\link{ft_word2vec}()}
}
\concept{feature transformers}
