% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSparseMatrix.R
\name{create_sparse_matrix}
\alias{create_sparse_matrix}
\title{Create Sparse Matrix}
\usage{
create_sparse_matrix(
  n,
  sparsity,
  method = "normal",
  stationary = FALSE,
  p = 1,
  ...
)
}
\arguments{
\item{n}{the dimension of the square matrix}

\item{sparsity}{the density of non zero elements}

\item{method}{the method used to generate the entries of the matrix.
Possible values are \code{"normal"} (default) or \code{"bimodal"}.}

\item{stationary}{should the spectral radius of the matrix be smaller than 1?
Possible values are \code{TRUE} or \code{FALSE}. Default is \code{FALSE}.}

\item{p}{normalization constant (used for VAR of order greater than 1,
default = 1)}

\item{...}{other options for the matrix (you can specify the mean
\code{mu_mat} and the standard deviation \code{sd_mat}).}
}
\value{
An nxn sparse matrix.
}
\description{
Creates a sparse square matrix with a given sparsity and
distribution.
}
\examples{
M <- create_sparse_matrix(
  n = 30, sparsity = 0.05, method = "normal",
  stationary = TRUE
)
}
