% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_spatial_predictors.R
\name{filter_spatial_predictors}
\alias{filter_spatial_predictors}
\title{Remove redundant spatial predictors}
\usage{
filter_spatial_predictors(
  data = NULL,
  predictor.variable.names = NULL,
  spatial.predictors.df = NULL,
  cor.threshold = 0.5
)
}
\arguments{
\item{data}{Data frame containing the predictor variables. Default: \code{NULL}.}

\item{predictor.variable.names}{Character vector of non-spatial predictor names. Must match column names in \code{data}. Can also be a \code{variable_selection} object. Default: \code{NULL}.}

\item{spatial.predictors.df}{Data frame of spatial predictors (e.g., from \code{\link[=mem_multithreshold]{mem_multithreshold()}}). Default: \code{NULL}.}

\item{cor.threshold}{Numeric between 0 and 1 (recommended: 0.5 to 0.75). Maximum allowed absolute Pearson correlation. Default: \code{0.50}.}
}
\value{
Data frame containing only spatial predictors with correlations below \code{cor.threshold} (both among themselves and with non-spatial predictors).
}
\description{
Removes spatial predictors that are highly correlated with other spatial predictors or with non-spatial predictors. Particularly useful when using multiple distance thresholds that produce correlated spatial predictors.
}
\details{
Filtering is performed in two steps:
\enumerate{
\item Remove spatial predictors correlated with each other (using \code{\link[=auto_cor]{auto_cor()}})
\item Remove spatial predictors correlated with non-spatial predictors
}
This two-step process ensures the retained spatial predictors are independent of both each other and the environmental predictors, improving model interpretability and reducing multicollinearity.
}
\examples{
data(
  plants_df,
  plants_predictors,
  plants_distance
)

# Generate spatial predictors using multiple distance thresholds
mem.df <- mem_multithreshold(
  distance.matrix = plants_distance,
  distance.thresholds = c(0, 1000)
)

# Filter spatial predictors to remove redundancy
# Removes spatial predictors correlated > 0.50 with each other
# or with environmental predictors
spatial.predictors.filtered <- filter_spatial_predictors(
  data = plants_df,
  predictor.variable.names = plants_predictors,
  spatial.predictors.df = mem.df,
  cor.threshold = 0.50
)

# Check dimensions
ncol(mem.df)  # original number
ncol(spatial.predictors.filtered)  # after filtering

}
\seealso{
Other spatial_analysis: 
\code{\link{mem}()},
\code{\link{mem_multithreshold}()},
\code{\link{moran}()},
\code{\link{moran_multithreshold}()},
\code{\link{pca}()},
\code{\link{pca_multithreshold}()},
\code{\link{rank_spatial_predictors}()},
\code{\link{residuals_diagnostics}()},
\code{\link{residuals_test}()},
\code{\link{select_spatial_predictors_recursive}()},
\code{\link{select_spatial_predictors_sequential}()}
}
\concept{spatial_analysis}
