% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hspvb.R
\name{hspvb}
\alias{hspvb}
\title{Hierarchical Spike-and-Slab Variational Bayes (HSPVB) for High-Dimensional Linear Regression}
\usage{
hspvb(
  X,
  Y,
  mu_0 = NULL,
  omega_0 = NULL,
  c_pi_0 = NULL,
  d_pi_0 = NULL,
  a_prior_tau_b = 0.1,
  b_prior_tau_b = 1,
  tau_e = NULL,
  update_order = NULL,
  standardize = TRUE,
  intercept = TRUE,
  max_iter = 1000,
  tol = 1e-05,
  seed = 12376
)
}
\arguments{
\item{X}{A numeric matrix. The design matrix (n observations × p predictors).}

\item{Y}{A numeric vector. The response vector of length n.}

\item{mu_0}{Optional numeric vector. Initial variational means for regression coefficients.}

\item{omega_0}{Optional numeric vector. Initial spike probabilities.}

\item{c_pi_0}{Optional numeric. Prior Beta(a, b) parameter a for the spike probability \eqn{\pi}.}

\item{d_pi_0}{Optional numeric. Prior Beta(a, b) parameter b for the spike probability \eqn{\pi}.}

\item{a_prior_tau_b}{Optional numeric. Gamma prior shape parameter (a) for the slab precision \eqn{\tau_b}. Default is 1.}

\item{b_prior_tau_b}{Optional numeric. Gamma prior rate parameter (b) for the slab precision \eqn{\tau_b}. Default is 0.01.}

\item{tau_e}{Optional numeric. Known or estimated error precision \eqn{\tau_\epsilon}.}

\item{update_order}{Optional integer vector. The coordinate update order (0-indexed for C++).}

\item{standardize}{Logical. Center Y, and center and scale X. Default is TRUE.}

\item{intercept}{Logical. Whether to include an intercept. Default is TRUE.}

\item{max_iter}{Maximum number of iterations for the variational update. Default is 1000.}

\item{tol}{Convergence threshold for entropy change. Default is 1e-5.}

\item{seed}{Integer seed for initialization, passed to \code{get.initials}. Default is 12376.}
}
\value{
A list with posterior summaries including estimated coefficients (\code{mu}),
inclusion probabilities (\code{omega}), final expected slab precision (\code{tau_b}),
intercept (if applicable), convergence status, etc.
}
\description{
Fits a sparse linear regression model using variational inference with a Gamma prior on the slab precision (\eqn{\tau_b}).
The model uses spike-and-slab priors where the slab scale is adaptively learned.
}
\details{
This function acts as a wrapper for the C++ implementation of the variational Bayes algorithm
with a hierarchical Gamma prior on the slab precision, \eqn{\tau_b}.
}
\examples{
\donttest{
n <- 50
p <- 100
X <- matrix(rnorm(n * p), n, p)
Y <- X[,1] * 2 + rnorm(n)
result <- hspvb(X = X, Y = Y)
}
}
