% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncs_analysis.R, R/ncs_analysis_subgroup.R
\name{ncs_analysis}
\alias{ncs_analysis}
\alias{ncs_analysis_subgroup}
\title{Run a Natural Cubic Spline (NCS) Analysis.}
\usage{
ncs_analysis(
  data,
  response = "response",
  subject = "subject",
  arm = "arm",
  control_group,
  time_observed_continuous = "time_observed_continuous",
  df = 2,
  spline_basis = NULL,
  time_observed_index = "time_observed_index",
  time_scheduled_continuous = "time_scheduled_continuous",
  time_scheduled_baseline = 0,
  time_scheduled_label = "time_scheduled_label",
  covariates = ~1,
  cov_structs = c("us", "toeph", "ar1h", "csh", "cs"),
  cov_struct_group = NULL,
  mmrm_args = list(method = "Satterthwaite"),
  emmeans_args = list(nesting = NULL),
  average_nuisance = TRUE,
  conf.level = 0.95,
  change_in_bl_contrast_args = list(adjust = "none"),
  treatment_effect_contrast_args = list(adjust = "none"),
  confint_args = list(level = conf.level),
  return_models = FALSE,
  expand_spline_terms = TRUE
)

ncs_analysis_subgroup(
  data,
  response = "response",
  subject = "subject",
  arm = "arm",
  control_group,
  subgroup = "subgroup",
  subgroup_comparator = "subgroup1",
  time_observed_continuous = "time_observed_continuous",
  df = 2,
  spline_basis = NULL,
  time_observed_index = "time_observed_index",
  time_scheduled_continuous = "time_scheduled_continuous",
  time_scheduled_baseline = 0,
  time_scheduled_label = "time_scheduled_label",
  covariates = ~1,
  cov_structs = c("us", "toeph", "ar1h", "csh", "cs"),
  cov_struct_group = NULL,
  mmrm_args = list(method = "Satterthwaite"),
  emmeans_args = list(nesting = NULL),
  average_nuisance = TRUE,
  conf.level = 0.95,
  change_in_bl_contrast_args = list(adjust = "none"),
  treatment_effect_contrast_args = list(adjust = "none"),
  confint_args = list(level = conf.level),
  subgroup_interaction_test = TRUE,
  return_models = FALSE,
  expand_spline_terms = TRUE
)
}
\arguments{
\item{data}{(\verb{data frame})\cr data set supplied to the \code{data} argument of
\code{\link[mmrm:mmrm]{mmrm::mmrm()}} when fitting models. The supplied expression is
\link[rlang:enquo]{quoted} and must evaluate to a data frame. See \strong{Tidy
evaluation support}.}

\item{response}{(\code{numeric} or \code{string})\cr the response variable. It can be a
\code{string} identifying the name of an existing variable; otherwise, the
supplied expression will be \link[rlang:enquo]{quoted} and added to the formula
as is (see \strong{Tidy evaluation support}).}

\item{subject}{(\code{atomic} or \code{string})\cr the unique subject identifier
forwarded to the \code{subject} argument of \code{\link[mmrm:cov_struct]{mmrm::cov_struct()}}. Ignored if
\code{cov_structs} is a \code{list}. Can be a \code{string} identifying an existing
variable; otherwise the supplied expression will be \link[rlang:enquo]{quoted}
and turned into a \code{string} with \code{\link[rlang:expr_print]{rlang::expr_deparse()}} (see \strong{Tidy
evaluation support}).}

\item{arm}{(\code{factor} or \code{string})\cr the study arm. It must be a \code{string} or
a \link{name} identifying an existing variable (i.e., it cannot be a \link{call}). If
a name, it will be \link[rlang:enquo]{quoted} before being added to the model
formula (see \strong{Tidy evaluation support}). If it does not evaluate to a
\link{factor} or if \code{control_group} is not its first \link[=levels]{level}, the \code{data}
argument will be wrapped in a \code{\link[dplyr:mutate]{dplyr::mutate()}} call that forces this to be
the case.}

\item{control_group}{(\code{string})\cr the value in \code{arm} denoting the control
group. If necessary, \code{arm} will be preprocessed such that it is a factor
with \code{control_group} as its first level.}

\item{time_observed_continuous}{(\code{numeric} or \code{string})\cr the visit's
\emph{observed} time point. It must either be a \code{string} or a \link{name} identifying
an existing variable (i.e., it cannot be a \link{call}). If a name is provided,
it is \link[rlang:enquo]{quoted} and incorporated into the model formula as is
(see \strong{Tidy evaluation support}).}

\item{df}{(scalar \code{integer})\cr number of degrees of freedom to use to create
the spline basis. Passed to the \code{df} argument of \code{\link[=time_spline_basis]{time_spline_basis()}}.
Ignored if the \code{spline_basis} argument is not \code{NULL}.}

\item{spline_basis}{(\code{basis} \code{matrix})\cr a spline basis: probably a value
returned by \code{\link[=time_spline_basis]{time_spline_basis()}} (which wraps \code{\link[splines:ns]{splines::ns()}}). If \code{NULL}
(the default), then the spline basis will be the result of forwarding
\code{time_observed_continuous} and \code{df} to \code{\link[=time_spline_basis]{time_spline_basis()}}. See
\strong{Providing a spline basis}.}

\item{time_observed_index}{(\code{ordered} or \code{string})\cr the visit index that
the visit shall be associated with, based on the visit's \emph{observed} time
point. This will be passed as the \code{visits} argument of
\code{\link[mmrm:cov_struct]{mmrm::cov_struct()}}. It can be a \code{string} identifying an existing
variable; otherwise the supplied expression will be \link[rlang:enquo]{quoted}
and turned into a \code{string} with \code{\link[rlang:expr_print]{rlang::expr_deparse()}} (see \strong{Tidy
evaluation support}). If it does not evaluate to an \code{ordered} factor, it
will be wrapped with \code{\link[=as.ordered]{as.ordered()}}. Ignored if \code{cov_structs} is a \code{list}.}

\item{time_scheduled_continuous}{(\code{numeric} or \code{string})\cr the continuous
time point when the visit was \emph{scheduled} to occur. Its unique values will
identify the time points at which the marginal means and other results will
be calculated. It can be a \code{string} identifying an existing variable name;
otherwise the supplied expression will be \link[rlang:enquo]{quoted} before
being evaluated (see \strong{Tidy evaluation support}).}

\item{time_scheduled_baseline}{(\verb{scalar numeric})\cr the continuous time
point when baseline was \emph{scheduled} to occur. Defaults to 0.}

\item{time_scheduled_label}{(\code{character} or \code{string})\cr the label associated
with the scheduled visit. It can be a \code{string} identifying an existing
variable name; otherwise the supplied expression will be
\link[rlang:enquo]{quoted} before being evaluated (see \strong{Tidy evaluation
support}).}

\item{covariates}{(\code{formula})\cr formula containing additional terms that
should be added to the \code{mmrm} model. Defaults to \code{~ 1}, in which no
additional terms will be added. Must not have a left side. Cannot contain
\code{.}. To specify that the model shall not have an intercept, use include \code{+ 0} or \code{- 1} in this formula.}

\item{cov_structs}{(\code{character} or \code{list})\cr either a \code{list} of unique
\code{\link[mmrm:cov_struct]{cov_struct}} objects or a \code{character} vector of one or
more of the covariance structure abbreviations as described in
\code{\link[mmrm:covariance_types]{mmrm::cov_types()}}. These covariance structures will be attempted in order
until one of them achieves a converging model fit. Defaults to \code{c("us", "toeph", "ar1h", "csh", "cs")}.}

\item{cov_struct_group}{(\code{atomic} or \code{string})\cr optional grouping variable
to be passed to the \code{group} argument of \code{\link[mmrm:cov_struct]{mmrm::cov_struct()}}. It can be a
\code{string} identifying an existing variable name; otherwise the supplied
expression will be \link[rlang:enquo]{quoted} and turned into a \code{string} with
\code{\link[rlang:expr_print]{rlang::expr_deparse()}} (see \strong{Tidy evaluation support}). Ignored if
\code{cov_structs} is a \code{list}. Defaults to \code{NULL}, in which case no grouping
variable will be used.}

\item{mmrm_args}{(named \code{list})\cr arguments to be passed to \code{\link[mmrm:mmrm]{mmrm::mmrm()}}.
If any elements have the names \code{formula}, \code{data}, or \code{covariance} they will
be ignored. An element named \code{vcov} will also be ignored unless fitting a
model with an unstructured covariance. Defaults to \code{list(method = "Satterthwaite")}.}

\item{emmeans_args}{(named \code{list})\cr arguments to be passed to
\code{\link[emmeans:emmeans]{emmeans::emmeans()}}. If any elements have the names \code{object} \code{specs}, or
\code{at} they will be ignored. If \code{average_nuisance = TRUE}, any element named
\code{nuisance} will be ignored. Any elements named \code{params} may be ignored.
Defaults to \code{list(nesting = NULL)}.}

\item{average_nuisance}{(\code{flag})\cr flag indicating whether the names of the
terms in \code{covariates} should be supplied as the \code{nuisance} argument to
\code{\link[emmeans:emmeans]{emmeans::emmeans()}}. This results in treating all the covariates as
nuisance parameters and averaging over them when calculating the reference
grid to estimate marginal means. See \code{\link[emmeans:ref_grid]{emmeans::ref_grid()}} for details and
limitations.}

\item{conf.level}{(scalar \code{numeric})\cr confidence level for the calculation
of p-values. Defaults to \code{0.95}.}

\item{change_in_bl_contrast_args, treatment_effect_contrast_args}{(named
\code{list})\cr arguments to be passed to \code{\link[emmeans:contrast]{emmeans::contrast()}} when calculating
the change from baseline and treatment effect results. If any elements have
the names \code{object} or \code{method} they will be ignored. Defaults to
\code{list(adjust = "none")}.}

\item{confint_args}{(named \code{list})\cr arguments to be passed to
\code{\link[stats:confint]{stats::confint()}} when calculating confidence intervals for change in
baseline and treatment effect. If any element has the name \code{object} it will
be ignored. Defaults to \code{list(level = conf.level)}.}

\item{return_models}{(\code{flag})\cr flag indicating whether or not to return the
model(s) used to calculate the results. See \strong{Obtaining the models used}
below.}

\item{expand_spline_terms}{(\code{flag})\cr flag indicating whether or not to
separate the cubic spline matrix into separate terms (one for each degree
of freedom). Defaults to \code{TRUE}. See \strong{Expanding spline terms}.}

\item{subgroup}{(\code{factor} or \code{string})\cr the subgroup. It must be a \code{string}
or a \link{name} identifying an existing variable (i.e., it cannot be a \link{call}).
If a name, it will be \link[rlang:enquo]{quoted} before being added to the
model formula (see \strong{Tidy evaluation support}). If it does not evaluate to
a \link{factor} or if \code{subgroup_comparator} is not its first \link[=levels]{level},
the \code{data} argument will be wrapped in a \code{\link[dplyr:mutate]{dplyr::mutate()}} call that forces
this to be the case.}

\item{subgroup_comparator}{(\code{string})\cr the value in \code{subgroup} denoting the
"main" subgroup that all other subgroups should be compared to. If
necessary, \code{subgroup} will be preprocessed such that it is a factor with
\code{control_group} as its first level.}

\item{subgroup_interaction_test}{(\code{flag})\cr flag indicating whether or not
the subgroup interaction test should be performed. If \code{TRUE}, the returned
value will include an \code{interaction} element, a data frame of results.
Defaults to \code{TRUE}. See \strong{Subgroup interaction test} for details.}
}
\value{
For \code{ncs_analysis()}, see \code{\linkS4class{splinetrials_analysis}}. For
\code{ncs_analysis_subgroup()}, see \code{\linkS4class{splinetrials_subgroup_analysis}}.
}
\description{
Fit and analyze an \code{\link[mmrm:mmrm]{mmrm}} model wherein the
continuous time variable has splines applied.
\itemize{
\item \code{ncs_analysis()} fits such a model without involving subgroups.
\item \code{ncs_analysis_subgroup()} fits a model that involves subgroups and
performs additional analyses.
}
}
\section{Overview}{
These functions create an \code{\link[mmrm:mmrm]{mmrm}} model from the user-specified
arguments. They then perform a series of analyses and produce a data frame of
results with a unique row for each combination of \code{arm},
\code{time_scheduled_continuous}, and \code{subgroup} (for \code{ncs_analysis_subgroup()}
only). The results include:
\enumerate{
\item Basic diagnostics on the response variable
\item Estimated marginal means
\item Change from baseline
\item Treatment effect
\item Percent slowing
}
}

\section{Building a model}{
See the details of \code{\link[=ncs_mmrm_fit]{ncs_mmrm_fit()}} for information on how the model is
built.
}

\section{Subgroup analysis}{
\code{ncs_analysis_subgroup()} contains more analyses and results than
\code{ncs_analysis()}. Whereas the latter produces a data frame by default, the
former produces a list of data frames.
\subsection{Treatment effects}{

The treatment effect is calculated twice: once \emph{between} subgroups (examining
the differences between the subgroups within each study arm) and once
\emph{within} subgroups (examining the differences between the study arms within
each subgroup). The main results table is effectively returned twice as both
the \code{between} element and the \code{within} element. These elements' treatment
effect values differ, and only the \code{within} element contains the percent
slowing analysis results.
}

\subsection{Type-III ANOVA}{

The subgroup analyses include a type-III analysis of variance (ANOVA) on the
main analysis model's terms, using a Chi-squared test statistic. This is
accomplished via the \code{mmrm} method for \code{\link[car:Anova]{car::Anova()}}. The results are
included in the returned value as the \code{type3} element. See
\code{vignette("hypothesis_testing", "mmrm")} for details on the type-III ANOVA.
}

\subsection{Subgroup interaction test}{

When \code{subgroup_interaction_test = TRUE}, the function runs an ANOVA to
compare a maximum-likelihood-estimated (ML) version of the original model to
a reduced version. This happens as follows:
\enumerate{
\item The original analysis model is refit with \code{reml = FALSE} if it was
originally created with \code{reml = TRUE}. This may be dubbed the "full" model.
\item A reduced version of the "full" model is created, removing the
second-order interaction term (see the \strong{\code{arm} and \code{subgroup} terms} section
above). This may be dubbed the "reduced" model.
\item The "full" and "reduced" models are compared using the \code{mmrm} method of
\code{stats::anova()}.
\item The results are processed into a table and added to the returned value as
the \code{interaction} element.
}
}
}

\section{Returning the models used}{
The model(s) used to conduct the analyses can be obtained by setting
\code{return_models = TRUE}.

For \code{ncs_analysis()}, the analysis model will be included as the
\code{splinetrials_analysis_model} \link{attr}ibute of the returned value.

For \code{ncs_analysis_subgroup()}, the analysis model is added to the returned
value as the \code{analysis_model} element. Furthermore, if
\code{subgroup_interaction_test = TRUE}, the "full" and "reduced" models will be
included in the returned value as the elements \code{full} and \code{reduced} (see
\strong{Subgroup interaction test} above for details).
}

\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
# Create a usable data set out of mmrm::fev_data
fev_mod <- mmrm::fev_data
fev_mod$VISITN <- fev_mod$VISITN * 10
fev_mod$time_cont <- fev_mod$VISITN + rnorm(nrow(fev_mod))
fev_mod$obs_visit_index <- round(fev_mod$time_cont)

# Without subgroup:
ncs_analysis(
  data = fev_mod,
  response = FEV1,
  subject = USUBJID,
  arm = ARMCD,
  control_group = "PBO",
  time_observed_continuous = time_cont,
  df = 2,
  time_observed_index = obs_visit_index,
  time_scheduled_continuous = VISITN,
  time_scheduled_baseline = 10,
  time_scheduled_label = AVISIT,
  covariates = ~ FEV1_BL + RACE,
  cov_structs = c("ar1", "us")
)

# With subgroup:
ncs_analysis_subgroup(
  data = fev_mod,
  response = FEV1,
  subject = USUBJID,
  arm = ARMCD,
  control_group = "PBO",
  subgroup = SEX,
  subgroup_comparator = "Male",
  time_observed_continuous = time_cont,
  df = 2,
  time_observed_index = obs_visit_index,
  time_scheduled_continuous = VISITN,
  time_scheduled_baseline = 10,
  time_scheduled_label = AVISIT,
  covariates = ~ FEV1_BL + RACE,
  cov_structs = c("ar1", "us")
)
\dontshow{\}) # examplesIf}
}
