% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncs_emmeans.R
\name{ncs_emmeans}
\alias{ncs_emmeans}
\title{Estimate Marginal Means for a Natural Cubic Splines Analysis}
\usage{
ncs_emmeans(
  fit,
  data = fit[["data"]],
  observed_time = NULL,
  scheduled_time = NULL,
  arm = NULL,
  subgroup = NULL,
  average_nuisance = TRUE,
  emmeans_args = list(nesting = NULL),
  ...,
  scheduled_time_spec = sort(unique(data[[scheduled_time]])),
  arm_spec = as.character(sort(unique(data[[arm]]))),
  subgroup_spec = as.character(sort(unique(data[[subgroup]]))),
  .__caller_env = rlang::caller_env()
)
}
\arguments{
\item{fit}{(\code{mmrm})\cr an \code{mmrm} object whose terms include the variables
supplied to \code{observed_time}, \code{scheduled_time}, \code{arm}, and (optionally)
\code{subgroup}.}

\item{data}{(\verb{data frame})\cr a data frame on which to estimate marginal
means. Defaults to \code{fit[["data"]]}.}

\item{observed_time}{(\code{string})\cr string specifying the \emph{observed}
continuous time variable in both \code{fit} and in \code{data}.}

\item{scheduled_time}{(\code{string})\cr string specifying the \emph{scheduled}
continuous time variable in both \code{fit} and in \code{data}. Ignored if
\code{scheduled_time_spec} is provided.}

\item{arm}{(\code{string})\cr string specifying the study arm variable in both
\code{fit} and in \code{data}.}

\item{subgroup}{(\code{string})\cr string specifying the subgroup variable in both
\code{fit} and in \code{data}.}

\item{average_nuisance}{(\code{flag})\cr flag indicating whether the names of the
terms in \code{covariates} should be supplied as the \code{nuisance} argument to
\code{\link[emmeans:emmeans]{emmeans::emmeans()}}. This results in treating all the covariates as
nuisance parameters and averaging over them when calculating the reference
grid to estimate marginal means. See \code{\link[emmeans:ref_grid]{emmeans::ref_grid()}} for details and
limitations.}

\item{emmeans_args, ...}{(named \code{list})\cr arguments to be passed to
\code{\link[emmeans:emmeans]{emmeans::emmeans()}}. If any elements have the names \code{object}, \code{specs}, or
\code{at} they will be ignored. If \code{average_nuisance = TRUE}, any element named
\code{nuisance} will be ignored. Any elements named \code{params} may be ignored.
\code{emmeans_args} defaults to \code{list(nesting = NULL)}. Arguments named in
\code{emmeans_args} supersede any named arguments in \code{...}.}

\item{scheduled_time_spec}{(\code{numeric})\cr vector of unique, non-missing time
points on which to calculate marginal means. Defaults to
\code{sort(unique(data[[scheduled_time]]))}.}

\item{arm_spec}{(\code{character})\cr vector of unique study arm values on which
to calculate marginal means. Defaults to
\code{as.character(sort(unique(data[[arm]])))}.}

\item{subgroup_spec}{vector of unique subgroup values on which to calculate
marginal means. Ignored if \code{subgroup} is \code{NULL}. Defaults to
\code{as.character(sort(unique(data[[subgroup]])))}.}

\item{.__caller_env}{(\code{environment})\cr the environment from which this
function was called. Defaults to \code{\link[rlang:stack]{rlang::caller_env()}}.}
}
\value{
An object of class \code{\link[emmeans:emmGrid-class]{emmGrid}}: the
result of \code{\link[emmeans:emmeans]{emmeans::emmeans()}}. Note that for a result \code{result}, the
elements \code{result@model.info$nesting} and \code{result@misc$display} are removed.
}
\description{
This is wrapper around \code{\link[emmeans:emmeans]{emmeans::emmeans()}} for a natural cubic
splines analysis in which there is a continuous time variable, a study arm,
and (optionally) a subgroup variable.
}
\examples{
# Create a usable data set out of mmrm::fev_data
fev_mod <- mmrm::fev_data
fev_mod$VISITN <- fev_mod$VISITN * 10
fev_mod$time_cont <- fev_mod$VISITN + rnorm(nrow(fev_mod))
fev_mod$obs_visit_index <- round(fev_mod$time_cont)

fit <-
  ncs_mmrm_fit(
    data = fev_mod,
    type = "subgroup_full",
    response = FEV1,
    subject = USUBJID,
    cov_structs = c("ar1", "us"),
    time_observed_continuous = time_cont,
    df = 2,
    time_observed_index = obs_visit_index,
    arm = ARMCD,
    control_group = "PBO",
    subgroup = SEX,
    subgroup_comparator = "Male",
    covariates = ~ FEV1_BL + RACE
  )

ncs_emmeans(
  fit = fit,
  observed_time = "time_cont",
  scheduled_time = "VISITN",
  arm = "ARMCD",
  subgroup = "SEX"
)
}
