# ncs_analysis() works

    Code
      print(test_ncs_analysis, width = Inf, n = Inf)
    Output
      # A tibble: 24 x 32
         arm     time         n   est    sd    se lower upper response_est response_se
         <fct>   <chr>    <int> <dbl> <dbl> <dbl> <dbl> <dbl>        <dbl>       <dbl>
       1 active1 Baseline    19 10.0  1.04  0.240  9.57 10.5          9.95       0.127
       2 active1 visit 3     19  9.13 0.909 0.208  8.72  9.54         9.40       0.105
       3 active1 visit 4     19  9.02 1.10  0.253  8.53  9.52         8.94       0.144
       4 active1 visit 5     19  9.08 0.969 0.222  8.65  9.52         8.69       0.138
       5 active1 visit 7     19  8.57 1.17  0.268  8.05  9.10         8.63       0.134
       6 active1 visit 8     19  8.72 0.861 0.198  8.34  9.11         8.70       0.150
       7 active1 visit 9     19  9.16 1.21  0.278  8.61  9.70         8.84       0.126
       8 active1 visit 12    19  8.83 0.851 0.195  8.45  9.21         9.03       0.183
       9 active2 Baseline    13 10.3  0.883 0.245  9.82 10.8          9.95       0.127
      10 active2 visit 3     13  8.49 1.10  0.304  7.90  9.09         9.19       0.120
      11 active2 visit 4     13  8.85 0.657 0.182  8.50  9.21         8.54       0.174
      12 active2 visit 5     13  7.65 1.34  0.372  6.92  8.38         8.11       0.168
      13 active2 visit 7     13  7.84 1.05  0.291  7.27  8.41         7.90       0.165
      14 active2 visit 8     13  8.22 0.997 0.277  7.68  8.76         7.85       0.182
      15 active2 visit 9     13  7.46 0.938 0.260  6.95  7.97         7.92       0.154
      16 active2 visit 12    13  8.05 0.989 0.274  7.51  8.59         8.04       0.223
      17 control Baseline    18 10.0  0.921 0.217  9.60 10.4          9.95       0.127
      18 control visit 3     18  8.52 1.09  0.258  8.01  9.02         8.90       0.106
      19 control visit 4     18  8.22 0.889 0.210  7.81  8.63         8.00       0.149
      20 control visit 5     18  7.08 1.07  0.253  6.59  7.58         7.36       0.143
      21 control visit 7     18  7.04 0.849 0.200  6.64  7.43         6.95       0.138
      22 control visit 8     18  6.87 0.769 0.181  6.51  7.22         6.63       0.153
      23 control visit 9     18  6.08 0.953 0.225  5.64  6.52         6.29       0.129
      24 control visit 12    18  5.95 0.936 0.221  5.51  6.38         5.91       0.186
         response_df response_lower response_upper change_est change_se change_df
               <dbl>          <dbl>          <dbl>      <dbl>     <dbl>     <dbl>
       1        50.4           9.69          10.2      NA        NA          NA  
       2        61.5           9.19           9.61     -0.552     0.120      74.6
       3        50.7           8.66           9.23     -1.00      0.197      75.3
       4        52.6           8.41           8.96     -1.26      0.209      73.9
       5        49.6           8.36           8.90     -1.32      0.204      73.4
       6        49.0           8.40           9.00     -1.25      0.208      73.4
       7        47.1           8.59           9.10     -1.10      0.188      72.0
       8        48.8           8.66           9.40     -0.920     0.232      70.4
       9        50.4           9.69          10.2      NA        NA          NA  
      10        62.4           8.95           9.43     -0.760     0.136      81.4
      11        52.4           8.19           8.89     -1.41      0.223      83.9
      12        53.8           7.77           8.44     -1.84      0.232      85.2
      13        51.0           7.57           8.23     -2.05      0.227      83.1
      14        50.3           7.49           8.22     -2.10      0.232      79.1
      15        48.1           7.61           8.23     -2.03      0.208      78.9
      16        49.4           7.59           8.49     -1.91      0.264      72.2
      17        50.4           9.69          10.2      NA        NA          NA  
      18        60.9           8.69           9.11     -1.05      0.123      79.2
      19        52.1           7.70           8.29     -1.95      0.203      80.0
      20        54.4           7.07           7.64     -2.59      0.214      78.1
      21        49.4           6.67           7.23     -3.00      0.208      76.0
      22        48.2           6.32           6.94     -3.32      0.210      74.6
      23        46.7           6.03           6.55     -3.66      0.190      73.7
      24        48.8           5.53           6.28     -4.04      0.234      72.2
         change_lower change_upper change_test_statistic change_p_value diff_est
                <dbl>        <dbl>                 <dbl>          <dbl>    <dbl>
       1       NA           NA                     NA         NA          NA    
       2       -0.790       -0.313                 -4.61       1.63e- 5    0.494
       3       -1.40        -0.610                 -5.08       2.66e- 6    0.950
       4       -1.67        -0.843                 -6.04       5.83e- 8    1.33 
       5       -1.73        -0.913                 -6.46       9.98e- 9    1.68 
       6       -1.66        -0.835                 -6.02       6.41e- 8    2.07 
       7       -1.48        -0.729                 -5.87       1.25e- 7    2.56 
       8       -1.38        -0.457                 -3.97       1.73e- 4    3.12 
       9       NA           NA                     NA         NA          NA    
      10       -1.03        -0.489                 -5.58       3.04e- 7    0.286
      11       -1.85        -0.965                 -6.32       1.20e- 8    0.545
      12       -2.30        -1.38                  -7.93       7.70e-12    0.751
      13       -2.50        -1.60                  -9.04       5.44e-14    0.948
      14       -2.56        -1.63                  -9.02       8.81e-14    1.22 
      15       -2.44        -1.62                  -9.78       2.96e-15    1.63 
      16       -2.43        -1.38                  -7.22       4.36e-10    2.14 
      17       NA           NA                     NA         NA          NA    
      18       -1.29        -0.800                 -8.47       1.02e-12   NA    
      19       -2.36        -1.55                  -9.60       5.82e-15   NA    
      20       -3.02        -2.17                 -12.1        1.34e-19   NA    
      21       -3.41        -2.59                 -14.4        1.73e-23   NA    
      22       -3.73        -2.90                 -15.8        1.67e-25   NA    
      23       -4.04        -3.28                 -19.3        1.58e-30   NA    
      24       -4.51        -3.58                 -17.3        2.15e-27   NA    
         diff_se diff_df diff_lower diff_upper diff_test_statistic diff_p_value
           <dbl>   <dbl>      <dbl>      <dbl>               <dbl>        <dbl>
       1  NA        NA     NA           NA                   NA       NA       
       2   0.132    50.8    0.229        0.759                3.74     4.67e- 4
       3   0.206    50.3    0.536        1.36                 4.61     2.83e- 5
       4   0.191    48.1    0.948        1.72                 6.97     8.22e- 9
       5   0.187    45.7    1.30         2.06                 8.99     1.14e-11
       6   0.212    47.5    1.64         2.49                 9.74     6.64e-13
       7   0.179    46.1    2.20         2.92                14.3      1.45e-18
       8   0.259    47.8    2.60         3.64                12.0      4.44e-16
       9  NA        NA     NA           NA                   NA       NA       
      10   0.147    53.1   -0.00755      0.580                1.95     5.60e- 2
      11   0.230    52.7    0.0835       1.01                 2.37     2.15e- 2
      12   0.216    50.4    0.317        1.19                 3.47     1.07e- 3
      13   0.212    48.3    0.522        1.37                 4.47     4.70e- 5
      14   0.238    49.8    0.743        1.70                 5.13     4.82e- 6
      15   0.202    48.1    1.22         2.04                 8.08     1.66e-10
      16   0.291    49.5    1.55         2.72                 7.34     1.84e- 9
      17  NA        NA     NA           NA                   NA       NA       
      18  NA        NA     NA           NA                   NA       NA       
      19  NA        NA     NA           NA                   NA       NA       
      20  NA        NA     NA           NA                   NA       NA       
      21  NA        NA     NA           NA                   NA       NA       
      22  NA        NA     NA           NA                   NA       NA       
      23  NA        NA     NA           NA                   NA       NA       
      24  NA        NA     NA           NA                   NA       NA       
         percent_slowing_est percent_slowing_lower percent_slowing_upper
                       <dbl>                 <dbl>                 <dbl>
       1                NA                   NA                     NA  
       2                47.2                 21.7                   72.8
       3                48.6                 26.2                   71.1
       4                51.4                 33.8                   69.1
       5                56.0                 41.4                   70.6
       6                62.4                 49.2                   75.5
       7                69.9                 59.3                   80.4
       8                77.2                 65.7                   88.8
       9                NA                   NA                     NA  
      10                27.4                 -3.15                  57.9
      11                27.9                  1.12                  54.7
      12                29.0                  8.01                  50.0
      13                31.6                 14.1                   49.1
      14                36.8                 21.0                   52.6
      15                44.5                 32.1                   57.0
      16                52.9                 39.0                   66.7
      17                NA                   NA                     NA  
      18                NA                   NA                     NA  
      19                NA                   NA                     NA  
      20                NA                   NA                     NA  
      21                NA                   NA                     NA  
      22                NA                   NA                     NA  
      23                NA                   NA                     NA  
      24                NA                   NA                     NA  
         correlation                optimizer
         <chr>                      <chr>    
       1 heterogeneous unstructured mmrm+tmb 
       2 heterogeneous unstructured mmrm+tmb 
       3 heterogeneous unstructured mmrm+tmb 
       4 heterogeneous unstructured mmrm+tmb 
       5 heterogeneous unstructured mmrm+tmb 
       6 heterogeneous unstructured mmrm+tmb 
       7 heterogeneous unstructured mmrm+tmb 
       8 heterogeneous unstructured mmrm+tmb 
       9 heterogeneous unstructured mmrm+tmb 
      10 heterogeneous unstructured mmrm+tmb 
      11 heterogeneous unstructured mmrm+tmb 
      12 heterogeneous unstructured mmrm+tmb 
      13 heterogeneous unstructured mmrm+tmb 
      14 heterogeneous unstructured mmrm+tmb 
      15 heterogeneous unstructured mmrm+tmb 
      16 heterogeneous unstructured mmrm+tmb 
      17 heterogeneous unstructured mmrm+tmb 
      18 heterogeneous unstructured mmrm+tmb 
      19 heterogeneous unstructured mmrm+tmb 
      20 heterogeneous unstructured mmrm+tmb 
      21 heterogeneous unstructured mmrm+tmb 
      22 heterogeneous unstructured mmrm+tmb 
      23 heterogeneous unstructured mmrm+tmb 
      24 heterogeneous unstructured mmrm+tmb 

# ncs_analysis_subgroup() works

    Code
      print(test_ncs_analysis_subgroup$between, width = Inf, n = Inf)
    Output
      # A tibble: 72 x 30
         arm     time     subgroup      n   est    sd     se lower upper response_est
         <fct>   <chr>    <fct>     <int> <dbl> <dbl>  <dbl> <dbl> <dbl>        <dbl>
       1 active1 Baseline subgroup1     3 10.5  0.374 0.216  10.1  10.9         10.4 
       2 active1 Baseline subgroup2     4 10.8  1.31  0.654   9.48 12.0         10.0 
       3 active1 Baseline subgroup3     3  9.83 0.522 0.301   9.24 10.4          9.86
       4 active2 Baseline subgroup1     3 10.6  1.41  0.816   8.99 12.2         10.4 
       5 active2 Baseline subgroup2     3 10.5  2.06  1.19    8.12 12.8         10.0 
       6 active2 Baseline subgroup3     4 10.1  1.26  0.630   8.85 11.3          9.86
       7 control Baseline subgroup1     4 10.3  0.252 0.126  10.0  10.5         10.4 
       8 control Baseline subgroup2     3  9.26 0.825 0.476   8.33 10.2         10.0 
       9 control Baseline subgroup3     3 10.1  0.874 0.504   9.06 11.0          9.86
      10 active1 visit 3  subgroup1     3  9.50 0.284 0.164   9.18  9.82         9.66
      11 active1 visit 3  subgroup2     4  8.87 0.849 0.425   8.03  9.70         9.20
      12 active1 visit 3  subgroup3     3  9.87 0.637 0.368   9.15 10.6         10.1 
      13 active2 visit 3  subgroup1     3  8.90 1.71  0.985   6.97 10.8          8.91
      14 active2 visit 3  subgroup2     3  9.89 1.06  0.612   8.69 11.1          9.20
      15 active2 visit 3  subgroup3     4  8.57 0.881 0.441   7.71  9.44         8.91
      16 control visit 3  subgroup1     4  8.84 1.13  0.564   7.73  9.94         9.14
      17 control visit 3  subgroup2     3  7.43 2.23  1.29    4.91  9.95         8.41
      18 control visit 3  subgroup3     3  8.84 0.134 0.0775  8.68  8.99         9.12
      19 active1 visit 4  subgroup1     3  9.49 0.598 0.345   8.81 10.2          9.05
      20 active1 visit 4  subgroup2     4  9.26 1.18  0.590   8.10 10.4          8.66
      21 active1 visit 4  subgroup3     3  9.98 1.43  0.828   8.36 11.6         10.1 
      22 active2 visit 4  subgroup1     3  7.83 1.24  0.715   6.43  9.23         7.74
      23 active2 visit 4  subgroup2     3  7.96 1.25  0.721   6.55  9.37         8.58
      24 active2 visit 4  subgroup3     4  8.02 0.367 0.183   7.66  8.38         8.14
      25 control visit 4  subgroup1     4  8.32 0.933 0.467   7.41  9.24         8.05
      26 control visit 4  subgroup2     3  7.19 0.366 0.211   6.77  7.60         7.23
      27 control visit 4  subgroup3     3  9.69 0.459 0.265   9.17 10.2          8.44
      28 active1 visit 5  subgroup1     3  8.27 0.703 0.406   7.47  9.06         8.72
      29 active1 visit 5  subgroup2     4  9.07 0.280 0.140   8.80  9.35         8.61
      30 active1 visit 5  subgroup3     3  9.67 0.550 0.317   9.05 10.3          9.69
      31 active2 visit 5  subgroup1     3  7.66 0.284 0.164   7.34  7.98         7.27
      32 active2 visit 5  subgroup2     3  8.48 2.81  1.62    5.30 11.7          8.33
      33 active2 visit 5  subgroup3     4  8.21 1.05  0.526   7.18  9.24         7.73
      34 control visit 5  subgroup1     4  7.26 1.15  0.576   6.13  8.39         7.32
      35 control visit 5  subgroup2     3  8.11 0.724 0.418   7.30  8.93         6.88
      36 control visit 5  subgroup3     3  7.14 1.27  0.736   5.70  8.59         7.91
      37 active1 visit 7  subgroup1     3  8.53 0.800 0.462   7.63  9.44         8.68
      38 active1 visit 7  subgroup2     4  8.35 1.10  0.548   7.28  9.43         8.96
      39 active1 visit 7  subgroup3     3  9.99 1.14  0.661   8.70 11.3          8.92
      40 active2 visit 7  subgroup1     3  8.05 1.48  0.857   6.37  9.73         7.45
      41 active2 visit 7  subgroup2     3  8.35 0.403 0.233   7.89  8.81         8.39
      42 active2 visit 7  subgroup3     4  7.53 1.20  0.598   6.36  8.70         7.63
      43 control visit 7  subgroup1     4  7.29 1.28  0.641   6.03  8.55         6.97
      44 control visit 7  subgroup2     3  7.18 1.38  0.795   5.62  8.74         7.13
      45 control visit 7  subgroup3     3  6.46 0.960 0.554   5.37  7.54         7.49
      46 active1 visit 8  subgroup1     3  8.78 0.923 0.533   7.73  9.82         8.77
      47 active1 visit 8  subgroup2     4  8.64 0.500 0.250   8.15  9.13         9.26
      48 active1 visit 8  subgroup3     3  8.51 0.889 0.513   7.50  9.51         8.32
      49 active2 visit 8  subgroup1     3  7.40 1.28  0.739   5.95  8.85         7.81
      50 active2 visit 8  subgroup2     3  8.97 1.22  0.702   7.60 10.3          8.42
      51 active2 visit 8  subgroup3     4  7.79 1.06  0.528   6.75  8.82         7.54
      52 control visit 8  subgroup1     4  6.60 0.977 0.489   5.64  7.56         6.79
      53 control visit 8  subgroup2     3  6.99 1.08  0.624   5.77  8.21         7.08
      54 control visit 8  subgroup3     3  6.89 0.617 0.356   6.19  7.58         7.04
      55 active1 visit 9  subgroup1     3  8.99 0.128 0.0737  8.84  9.13         8.87
      56 active1 visit 9  subgroup2     4  9.33 0.828 0.414   8.52 10.1          9.15
      57 active1 visit 9  subgroup3     3  7.95 0.913 0.527   6.92  8.98         8.29
      58 active2 visit 9  subgroup1     3  8.11 0.822 0.474   7.18  9.04         8.00
      59 active2 visit 9  subgroup2     3  8.01 1.31  0.757   6.53  9.50         8.16
      60 active2 visit 9  subgroup3     4  6.27 0.677 0.338   5.61  6.93         7.25
      61 control visit 9  subgroup1     4  6.66 1.52  0.759   5.18  8.15         6.61
      62 control visit 9  subgroup2     3  5.45 0.809 0.467   4.53  6.36         6.07
      63 control visit 9  subgroup3     3  6.67 1.35  0.777   5.15  8.19         6.45
      64 active1 visit 12 subgroup1     3  8.91 0.386 0.223   8.47  9.34         8.96
      65 active1 visit 12 subgroup2     4  8.14 0.938 0.469   7.22  9.06         8.74
      66 active1 visit 12 subgroup3     3  8.94 0.772 0.446   8.07  9.82         8.66
      67 active2 visit 12 subgroup1     3  7.96 0.292 0.169   7.63  8.29         8.03
      68 active2 visit 12 subgroup2     3  7.66 0.917 0.530   6.62  8.70         7.68
      69 active2 visit 12 subgroup3     4  7.22 0.916 0.458   6.32  8.12         6.81
      70 control visit 12 subgroup1     4  6.33 1.52  0.760   4.84  7.82         6.43
      71 control visit 12 subgroup2     3  5.35 0.796 0.459   4.45  6.25         4.37
      72 control visit 12 subgroup3     3  5.61 0.897 0.518   4.60  6.63         5.76
         response_se response_df response_lower response_upper change_est change_se
               <dbl>       <dbl>          <dbl>          <dbl>      <dbl>     <dbl>
       1       0.250        27.8           9.91          10.9      NA        NA    
       2       0.255        28.6           9.48          10.5      NA        NA    
       3       0.248        28.7           9.35          10.4      NA        NA    
       4       0.250        27.8           9.91          10.9      NA        NA    
       5       0.255        28.6           9.48          10.5      NA        NA    
       6       0.248        28.7           9.35          10.4      NA        NA    
       7       0.250        27.8           9.91          10.9      NA        NA    
       8       0.255        28.6           9.48          10.5      NA        NA    
       9       0.248        28.7           9.35          10.4      NA        NA    
      10       0.231        26.8           9.19          10.1      -0.761     0.256
      11       0.216        26.0           8.76           9.65     -0.798     0.259
      12       0.229        25.3           9.64          10.6       0.251     0.259
      13       0.236        24.2           8.42           9.39     -1.52      0.279
      14       0.223        26.4           8.74           9.65     -0.806     0.253
      15       0.204        23.9           8.49           9.33     -0.949     0.257
      16       0.201        24.1           8.73           9.56     -1.28      0.250
      17       0.228        24.6           7.94           8.88     -1.59      0.273
      18       0.240        25.3           8.62           9.61     -0.743     0.277
      19       0.325        22.7           8.37           9.72     -1.38      0.417
      20       0.313        23.9           8.01           9.31     -1.34      0.425
      21       0.327        21.7           9.45          10.8       0.267     0.422
      22       0.352        22.7           7.01           8.47     -2.68      0.456
      23       0.314        21.5           7.93           9.23     -1.42      0.415
      24       0.302        23.2           7.52           8.77     -1.72      0.421
      25       0.292        22.0           7.44           8.66     -2.37      0.412
      26       0.335        21.9           6.54           7.93     -2.77      0.445
      27       0.353        23.2           7.71           9.17     -1.41      0.450
      28       0.316        23.3           8.06           9.37     -1.70      0.434
      29       0.295        24.2           8.00           9.22     -1.39      0.432
      30       0.311        22.1           9.04          10.3      -0.173     0.432
      31       0.338        23.2           6.57           7.97     -3.15      0.464
      32       0.311        22.2           7.69           8.98     -1.67      0.436
      33       0.287        24.4           7.14           8.32     -2.13      0.427
      34       0.287        23.3           6.73           7.92     -3.10      0.429
      35       0.329        23.0           6.20           7.56     -3.12      0.461
      36       0.333        24.0           7.23           8.60     -1.95      0.453
      37       0.366        21.3           7.92           9.44     -1.74      0.459
      38       0.287        22.5           8.37           9.56     -1.04      0.400
      39       0.334        21.6           8.22           9.61     -0.942     0.433
      40       0.340        20.9           6.74           8.15     -2.98      0.443
      41       0.356        21.2           7.65           9.13     -1.61      0.455
      42       0.284        20.6           7.03           8.22     -2.23      0.395
      43       0.297        20.5           6.35           7.59     -3.46      0.412
      44       0.361        20.7           6.38           7.88     -2.88      0.463
      45       0.338        22.3           6.79           8.19     -2.37      0.436
      46       0.418        21.2           7.91           9.64     -1.65      0.491
      47       0.346        23.8           8.55           9.97     -0.742     0.420
      48       0.405        22.4           7.48           9.16     -1.54      0.477
      49       0.401        21.6           6.98           8.65     -2.61      0.471
      50       0.413        21.5           7.56           9.28     -1.58      0.487
      51       0.340        21.5           6.84           8.25     -2.32      0.411
      52       0.351        20.6           6.06           7.51     -3.64      0.429
      53       0.408        20.6           6.23           7.93     -2.92      0.481
      54       0.394        22.3           6.22           7.86     -2.82      0.463
      55       0.270        20.2           8.31           9.44     -1.55      0.393
      56       0.264        21.3           8.60           9.70     -0.851     0.373
      57       0.299        19.8           7.66           8.91     -1.57      0.406
      58       0.293        19.8           7.39           8.61     -2.42      0.397
      59       0.280        19.7           7.57           8.74     -1.84      0.397
      60       0.252        19.6           6.73           7.78     -2.61      0.358
      61       0.258        19.3           6.08           7.15     -3.81      0.371
      62       0.269        19.7           5.51           6.64     -3.93      0.390
      63       0.278        20.5           5.87           7.03     -3.41      0.392
      64       0.500        23.2           7.93          10.00     -1.46      0.605
      65       0.310        22.9           8.10           9.38     -1.26      0.450
      66       0.350        21.7           7.93           9.38     -1.20      0.479
      67       0.348        21.7           7.31           8.75     -2.39      0.477
      68       0.412        22.2           6.82           8.53     -2.33      0.531
      69       0.328        21.9           6.13           7.49     -3.05      0.458
      70       0.301        22.0           5.80           7.05     -3.99      0.441
      71       0.489        22.5           3.35           5.38     -5.63      0.599
      72       0.443        23.9           4.84           6.67     -4.10      0.560
         change_df change_lower change_upper change_test_statistic change_p_value
             <dbl>        <dbl>        <dbl>                 <dbl>          <dbl>
       1      NA         NA          NA                     NA          NA       
       2      NA         NA          NA                     NA          NA       
       3      NA         NA          NA                     NA          NA       
       4      NA         NA          NA                     NA          NA       
       5      NA         NA          NA                     NA          NA       
       6      NA         NA          NA                     NA          NA       
       7      NA         NA          NA                     NA          NA       
       8      NA         NA          NA                     NA          NA       
       9      NA         NA          NA                     NA          NA       
      10      35.3       -1.28       -0.241                 -2.97        5.33e- 3
      11      34.2       -1.32       -0.271                 -3.08        4.10e- 3
      12      34.6       -0.275       0.777                  0.968       3.40e- 1
      13      35.7       -2.08       -0.949                 -5.43        4.13e- 6
      14      35.5       -1.32       -0.293                 -3.18        3.02e- 3
      15      40.7       -1.47       -0.430                 -3.69        6.52e- 4
      16      36.3       -1.79       -0.772                 -5.12        1.03e- 5
      17      38.0       -2.15       -1.04                  -5.85        9.13e- 7
      18      35.4       -1.31       -0.181                 -2.68        1.11e- 2
      19      36.6       -2.22       -0.531                 -3.30        2.16e- 3
      20      34.0       -2.21       -0.480                 -3.16        3.29e- 3
      21      35.5       -0.589       1.12                   0.633       5.31e- 1
      22      36.3       -3.60       -1.76                  -5.88        9.88e- 7
      23      36.8       -2.26       -0.582                 -3.43        1.50e- 3
      24      41.4       -2.57       -0.868                 -4.08        1.99e- 4
      25      37.0       -3.21       -1.54                  -5.75        1.34e- 6
      26      39.7       -3.67       -1.87                  -6.22        2.43e- 7
      27      36.4       -2.33       -0.503                 -3.14        3.31e- 3
      28      37.9       -2.58       -0.826                 -3.93        3.51e- 4
      29      33.1       -2.27       -0.514                 -3.23        2.83e- 3
      30      36.4       -1.05        0.703                 -0.400       6.92e- 1
      31      36.4       -4.09       -2.21                  -6.79        5.86e- 8
      32      38.3       -2.55       -0.786                 -3.83        4.65e- 4
      33      41.2       -2.99       -1.27                  -4.98        1.17e- 5
      34      37.1       -3.97       -2.23                  -7.22        1.41e- 8
      35      41.1       -4.05       -2.19                  -6.78        3.38e- 8
      36      37.7       -2.86       -1.03                  -4.30        1.17e- 4
      37      34.2       -2.68       -0.811                 -3.80        5.73e- 4
      38      31.7       -1.86       -0.225                 -2.60        1.40e- 2
      39      34.6       -1.82       -0.0622                -2.17        3.66e- 2
      40      33.7       -3.88       -2.08                  -6.72        1.08e- 7
      41      35.5       -2.53       -0.686                 -3.54        1.15e- 3
      42      35.7       -3.04       -1.43                  -5.65        2.08e- 6
      43      34.1       -4.29       -2.62                  -8.39        8.37e-10
      44      35.8       -3.81       -1.94                  -6.22        3.65e- 7
      45      35.5       -3.25       -1.48                  -5.43        4.14e- 6
      46      30.5       -2.65       -0.646                 -3.36        2.13e- 3
      47      29.6       -1.60        0.117                 -1.76        8.81e- 2
      48      30.8       -2.51       -0.564                 -3.22        3.00e- 3
      49      29.8       -3.57       -1.65                  -5.54        5.16e- 6
      50      31.6       -2.57       -0.587                 -3.24        2.79e- 3
      51      29.9       -3.16       -1.48                  -5.65        3.80e- 6
      52      29.9       -4.51       -2.76                  -8.47        1.92e- 9
      53      30.8       -3.90       -1.94                  -6.07        1.04e- 6
      54      31.0       -3.76       -1.87                  -6.09        9.63e- 7
      55      36.0       -2.35       -0.751                 -3.94        3.62e- 4
      56      30.7       -1.61       -0.0899                -2.28        2.96e- 2
      57      33.3       -2.40       -0.746                 -3.87        4.80e- 4
      58      32.7       -3.23       -1.61                  -6.09        7.53e- 7
      59      35.7       -2.65       -1.04                  -4.64        4.53e- 5
      60      32.6       -3.33       -1.88                  -7.28        2.52e- 8
      61      32.3       -4.56       -3.05                 -10.3         1.09e-11
      62      36.5       -4.72       -3.14                 -10.1         4.38e-12
      63      34.9       -4.20       -2.61                  -8.70        2.88e-10
      64      34.0       -2.69       -0.231                 -2.41        2.13e- 2
      65      33.6       -2.18       -0.348                 -2.81        8.27e- 3
      66      35.8       -2.18       -0.232                 -2.51        1.66e- 2
      67      35.1       -3.36       -1.43                  -5.02        1.50e- 5
      68      35.0       -3.41       -1.25                  -4.38        1.03e- 4
      69      36.3       -3.98       -2.12                  -6.67        8.60e- 8
      70      34.9       -4.89       -3.10                  -9.05        1.13e-10
      71      35.0       -6.85       -4.42                  -9.41        4.04e-11
      72      35.5       -5.24       -2.96                  -7.33        1.34e- 8
         diff_subgroup_est diff_subgroup_se diff_subgroup_df diff_subgroup_lower
                     <dbl>            <dbl>            <dbl>               <dbl>
       1           NA                NA                 NA              NA      
       2           NA                NA                 NA              NA      
       3           NA                NA                 NA              NA      
       4           NA                NA                 NA              NA      
       5           NA                NA                 NA              NA      
       6           NA                NA                 NA              NA      
       7           NA                NA                 NA              NA      
       8           NA                NA                 NA              NA      
       9           NA                NA                 NA              NA      
      10           NA                NA                 NA              NA      
      11           -0.0366            0.365             35.8            -0.777  
      12            1.01              0.364             35.5             0.273  
      13           NA                NA                 NA              NA      
      14            0.710             0.378             35.7            -0.0566 
      15            0.567             0.380             38.2            -0.202  
      16           NA                NA                 NA              NA      
      17           -0.315             0.368             37.8            -1.06   
      18            0.536             0.374             36.0            -0.223  
      19           NA                NA                 NA              NA      
      20            0.0340            0.596             36.0            -1.17   
      21            1.64              0.593             36.4             0.442  
      22           NA                NA                 NA              NA      
      23            1.26              0.618             36.5             0.00491
      24            0.962             0.621             38.9            -0.293  
      25           NA                NA                 NA              NA      
      26           -0.396             0.603             38.9            -1.62   
      27            0.957             0.612             36.9            -0.283  
      28           NA                NA                 NA              NA      
      29            0.312             0.613             35.8            -0.931  
      30            1.53              0.612             37.3             0.293  
      31           NA                NA                 NA              NA      
      32            1.48              0.638             37.4             0.192  
      33            1.02              0.631             38.9            -0.254  
      34           NA                NA                 NA              NA      
      35           -0.0243            0.625             39.8            -1.29   
      36            1.15              0.626             37.5            -0.116  
      37           NA                NA                 NA              NA      
      38            0.704             0.610             34.1            -0.535  
      39            0.802             0.631             34.8            -0.480  
      40           NA                NA                 NA              NA      
      41            1.37              0.636             35.0             0.0768 
      42            0.742             0.593             34.8            -0.462  
      43           NA                NA                 NA              NA      
      44            0.580             0.616             35.7            -0.669  
      45            1.09              0.602             34.9            -0.133  
      46           NA                NA                 NA              NA      
      47            0.907             0.647             31.1            -0.412  
      48            0.112             0.685             31.2            -1.28   
      49           NA                NA                 NA              NA      
      50            1.03              0.678             31.1            -0.355  
      51            0.291             0.624             30.1            -0.983  
      52           NA                NA                 NA              NA      
      53            0.719             0.642             30.7            -0.591  
      54            0.818             0.633             30.6            -0.473  
      55           NA                NA                 NA              NA      
      56            0.697             0.543             33.7            -0.405  
      57           -0.0230            0.565             35.0            -1.17   
      58           NA                NA                 NA              NA      
      59            0.576             0.563             34.6            -0.567  
      60           -0.186             0.534             33.0            -1.27   
      61           NA                NA                 NA              NA      
      62           -0.120             0.535             34.9            -1.21   
      63            0.399             0.541             34.1            -0.700  
      64           NA                NA                 NA              NA      
      65            0.199             0.755             35.9            -1.33   
      66            0.257             0.772             36.0            -1.31   
      67           NA                NA                 NA              NA      
      68            0.0664            0.715             35.4            -1.38   
      69           -0.660             0.662             35.8            -2.00   
      70           NA                NA                 NA              NA      
      71           -1.64              0.741             36.6            -3.14   
      72           -0.106             0.714             36.3            -1.55   
         diff_subgroup_upper diff_subgroup_test_statistic diff_subgroup_p_value
                       <dbl>                        <dbl>                 <dbl>
       1              NA                          NA                   NA      
       2              NA                          NA                   NA      
       3              NA                          NA                   NA      
       4              NA                          NA                   NA      
       5              NA                          NA                   NA      
       6              NA                          NA                   NA      
       7              NA                          NA                   NA      
       8              NA                          NA                   NA      
       9              NA                          NA                   NA      
      10              NA                          NA                   NA      
      11               0.704                      -0.100                0.921  
      12               1.75                        2.78                 0.00867
      13              NA                          NA                   NA      
      14               1.48                        1.88                 0.0684 
      15               1.34                        1.49                 0.144  
      16              NA                          NA                   NA      
      17               0.430                      -0.856                0.397  
      18               1.29                        1.43                 0.161  
      19              NA                          NA                   NA      
      20               1.24                        0.0571               0.955  
      21               2.85                        2.77                 0.00872
      22              NA                          NA                   NA      
      23               2.51                        2.03                 0.0492 
      24               2.22                        1.55                 0.129  
      25              NA                          NA                   NA      
      26               0.825                      -0.656                0.516  
      27               2.20                        1.56                 0.126  
      28              NA                          NA                   NA      
      29               1.55                        0.509                0.614  
      30               2.77                        2.50                 0.0168 
      31              NA                          NA                   NA      
      32               2.78                        2.33                 0.0255 
      33               2.30                        1.62                 0.113  
      34              NA                          NA                   NA      
      35               1.24                       -0.0389               0.969  
      36               2.42                        1.84                 0.0736 
      37              NA                          NA                   NA      
      38               1.94                        1.15                 0.256  
      39               2.08                        1.27                 0.212  
      40              NA                          NA                   NA      
      41               2.66                        2.15                 0.0385 
      42               1.95                        1.25                 0.219  
      43              NA                          NA                   NA      
      44               1.83                        0.942                0.353  
      45               2.31                        1.81                 0.0790 
      46              NA                          NA                   NA      
      47               2.23                        1.40                 0.171  
      48               1.51                        0.163                0.871  
      49              NA                          NA                   NA      
      50               2.41                        1.52                 0.140  
      51               1.56                        0.466                0.645  
      52              NA                          NA                   NA      
      53               2.03                        1.12                 0.271  
      54               2.11                        1.29                 0.206  
      55              NA                          NA                   NA      
      56               1.80                        1.29                 0.207  
      57               1.12                       -0.0406               0.968  
      58              NA                          NA                   NA      
      59               1.72                        1.02                 0.313  
      60               0.901                      -0.348                0.730  
      61              NA                          NA                   NA      
      62               0.966                      -0.224                0.824  
      63               1.50                        0.738                0.465  
      64              NA                          NA                   NA      
      65               1.73                        0.263                0.794  
      66               1.82                        0.333                0.741  
      67              NA                          NA                   NA      
      68               1.52                        0.0929               0.927  
      69               0.682                      -0.997                0.325  
      70              NA                          NA                   NA      
      71              -0.139                      -2.21                 0.0331 
      72               1.34                       -0.149                0.883  
         correlation                optimizer
         <chr>                      <chr>    
       1 heterogeneous unstructured mmrm+tmb 
       2 heterogeneous unstructured mmrm+tmb 
       3 heterogeneous unstructured mmrm+tmb 
       4 heterogeneous unstructured mmrm+tmb 
       5 heterogeneous unstructured mmrm+tmb 
       6 heterogeneous unstructured mmrm+tmb 
       7 heterogeneous unstructured mmrm+tmb 
       8 heterogeneous unstructured mmrm+tmb 
       9 heterogeneous unstructured mmrm+tmb 
      10 heterogeneous unstructured mmrm+tmb 
      11 heterogeneous unstructured mmrm+tmb 
      12 heterogeneous unstructured mmrm+tmb 
      13 heterogeneous unstructured mmrm+tmb 
      14 heterogeneous unstructured mmrm+tmb 
      15 heterogeneous unstructured mmrm+tmb 
      16 heterogeneous unstructured mmrm+tmb 
      17 heterogeneous unstructured mmrm+tmb 
      18 heterogeneous unstructured mmrm+tmb 
      19 heterogeneous unstructured mmrm+tmb 
      20 heterogeneous unstructured mmrm+tmb 
      21 heterogeneous unstructured mmrm+tmb 
      22 heterogeneous unstructured mmrm+tmb 
      23 heterogeneous unstructured mmrm+tmb 
      24 heterogeneous unstructured mmrm+tmb 
      25 heterogeneous unstructured mmrm+tmb 
      26 heterogeneous unstructured mmrm+tmb 
      27 heterogeneous unstructured mmrm+tmb 
      28 heterogeneous unstructured mmrm+tmb 
      29 heterogeneous unstructured mmrm+tmb 
      30 heterogeneous unstructured mmrm+tmb 
      31 heterogeneous unstructured mmrm+tmb 
      32 heterogeneous unstructured mmrm+tmb 
      33 heterogeneous unstructured mmrm+tmb 
      34 heterogeneous unstructured mmrm+tmb 
      35 heterogeneous unstructured mmrm+tmb 
      36 heterogeneous unstructured mmrm+tmb 
      37 heterogeneous unstructured mmrm+tmb 
      38 heterogeneous unstructured mmrm+tmb 
      39 heterogeneous unstructured mmrm+tmb 
      40 heterogeneous unstructured mmrm+tmb 
      41 heterogeneous unstructured mmrm+tmb 
      42 heterogeneous unstructured mmrm+tmb 
      43 heterogeneous unstructured mmrm+tmb 
      44 heterogeneous unstructured mmrm+tmb 
      45 heterogeneous unstructured mmrm+tmb 
      46 heterogeneous unstructured mmrm+tmb 
      47 heterogeneous unstructured mmrm+tmb 
      48 heterogeneous unstructured mmrm+tmb 
      49 heterogeneous unstructured mmrm+tmb 
      50 heterogeneous unstructured mmrm+tmb 
      51 heterogeneous unstructured mmrm+tmb 
      52 heterogeneous unstructured mmrm+tmb 
      53 heterogeneous unstructured mmrm+tmb 
      54 heterogeneous unstructured mmrm+tmb 
      55 heterogeneous unstructured mmrm+tmb 
      56 heterogeneous unstructured mmrm+tmb 
      57 heterogeneous unstructured mmrm+tmb 
      58 heterogeneous unstructured mmrm+tmb 
      59 heterogeneous unstructured mmrm+tmb 
      60 heterogeneous unstructured mmrm+tmb 
      61 heterogeneous unstructured mmrm+tmb 
      62 heterogeneous unstructured mmrm+tmb 
      63 heterogeneous unstructured mmrm+tmb 
      64 heterogeneous unstructured mmrm+tmb 
      65 heterogeneous unstructured mmrm+tmb 
      66 heterogeneous unstructured mmrm+tmb 
      67 heterogeneous unstructured mmrm+tmb 
      68 heterogeneous unstructured mmrm+tmb 
      69 heterogeneous unstructured mmrm+tmb 
      70 heterogeneous unstructured mmrm+tmb 
      71 heterogeneous unstructured mmrm+tmb 
      72 heterogeneous unstructured mmrm+tmb 

---

    Code
      print(test_ncs_analysis_subgroup$within, width = Inf, n = Inf)
    Output
      # A tibble: 72 x 33
         arm     time     subgroup      n   est    sd     se lower upper response_est
         <fct>   <chr>    <fct>     <int> <dbl> <dbl>  <dbl> <dbl> <dbl>        <dbl>
       1 active1 Baseline subgroup1     3 10.5  0.374 0.216  10.1  10.9         10.4 
       2 active1 visit 3  subgroup1     3  9.50 0.284 0.164   9.18  9.82         9.66
       3 active1 visit 4  subgroup1     3  9.49 0.598 0.345   8.81 10.2          9.05
       4 active1 visit 5  subgroup1     3  8.27 0.703 0.406   7.47  9.06         8.72
       5 active1 visit 7  subgroup1     3  8.53 0.800 0.462   7.63  9.44         8.68
       6 active1 visit 8  subgroup1     3  8.78 0.923 0.533   7.73  9.82         8.77
       7 active1 visit 9  subgroup1     3  8.99 0.128 0.0737  8.84  9.13         8.87
       8 active1 visit 12 subgroup1     3  8.91 0.386 0.223   8.47  9.34         8.96
       9 active2 Baseline subgroup1     3 10.6  1.41  0.816   8.99 12.2         10.4 
      10 active2 visit 3  subgroup1     3  8.90 1.71  0.985   6.97 10.8          8.91
      11 active2 visit 4  subgroup1     3  7.83 1.24  0.715   6.43  9.23         7.74
      12 active2 visit 5  subgroup1     3  7.66 0.284 0.164   7.34  7.98         7.27
      13 active2 visit 7  subgroup1     3  8.05 1.48  0.857   6.37  9.73         7.45
      14 active2 visit 8  subgroup1     3  7.40 1.28  0.739   5.95  8.85         7.81
      15 active2 visit 9  subgroup1     3  8.11 0.822 0.474   7.18  9.04         8.00
      16 active2 visit 12 subgroup1     3  7.96 0.292 0.169   7.63  8.29         8.03
      17 control Baseline subgroup1     4 10.3  0.252 0.126  10.0  10.5         10.4 
      18 control visit 3  subgroup1     4  8.84 1.13  0.564   7.73  9.94         9.14
      19 control visit 4  subgroup1     4  8.32 0.933 0.467   7.41  9.24         8.05
      20 control visit 5  subgroup1     4  7.26 1.15  0.576   6.13  8.39         7.32
      21 control visit 7  subgroup1     4  7.29 1.28  0.641   6.03  8.55         6.97
      22 control visit 8  subgroup1     4  6.60 0.977 0.489   5.64  7.56         6.79
      23 control visit 9  subgroup1     4  6.66 1.52  0.759   5.18  8.15         6.61
      24 control visit 12 subgroup1     4  6.33 1.52  0.760   4.84  7.82         6.43
      25 active1 Baseline subgroup2     4 10.8  1.31  0.654   9.48 12.0         10.0 
      26 active1 visit 3  subgroup2     4  8.87 0.849 0.425   8.03  9.70         9.20
      27 active1 visit 4  subgroup2     4  9.26 1.18  0.590   8.10 10.4          8.66
      28 active1 visit 5  subgroup2     4  9.07 0.280 0.140   8.80  9.35         8.61
      29 active1 visit 7  subgroup2     4  8.35 1.10  0.548   7.28  9.43         8.96
      30 active1 visit 8  subgroup2     4  8.64 0.500 0.250   8.15  9.13         9.26
      31 active1 visit 9  subgroup2     4  9.33 0.828 0.414   8.52 10.1          9.15
      32 active1 visit 12 subgroup2     4  8.14 0.938 0.469   7.22  9.06         8.74
      33 active2 Baseline subgroup2     3 10.5  2.06  1.19    8.12 12.8         10.0 
      34 active2 visit 3  subgroup2     3  9.89 1.06  0.612   8.69 11.1          9.20
      35 active2 visit 4  subgroup2     3  7.96 1.25  0.721   6.55  9.37         8.58
      36 active2 visit 5  subgroup2     3  8.48 2.81  1.62    5.30 11.7          8.33
      37 active2 visit 7  subgroup2     3  8.35 0.403 0.233   7.89  8.81         8.39
      38 active2 visit 8  subgroup2     3  8.97 1.22  0.702   7.60 10.3          8.42
      39 active2 visit 9  subgroup2     3  8.01 1.31  0.757   6.53  9.50         8.16
      40 active2 visit 12 subgroup2     3  7.66 0.917 0.530   6.62  8.70         7.68
      41 control Baseline subgroup2     3  9.26 0.825 0.476   8.33 10.2         10.0 
      42 control visit 3  subgroup2     3  7.43 2.23  1.29    4.91  9.95         8.41
      43 control visit 4  subgroup2     3  7.19 0.366 0.211   6.77  7.60         7.23
      44 control visit 5  subgroup2     3  8.11 0.724 0.418   7.30  8.93         6.88
      45 control visit 7  subgroup2     3  7.18 1.38  0.795   5.62  8.74         7.13
      46 control visit 8  subgroup2     3  6.99 1.08  0.624   5.77  8.21         7.08
      47 control visit 9  subgroup2     3  5.45 0.809 0.467   4.53  6.36         6.07
      48 control visit 12 subgroup2     3  5.35 0.796 0.459   4.45  6.25         4.37
      49 active1 Baseline subgroup3     3  9.83 0.522 0.301   9.24 10.4          9.86
      50 active1 visit 3  subgroup3     3  9.87 0.637 0.368   9.15 10.6         10.1 
      51 active1 visit 4  subgroup3     3  9.98 1.43  0.828   8.36 11.6         10.1 
      52 active1 visit 5  subgroup3     3  9.67 0.550 0.317   9.05 10.3          9.69
      53 active1 visit 7  subgroup3     3  9.99 1.14  0.661   8.70 11.3          8.92
      54 active1 visit 8  subgroup3     3  8.51 0.889 0.513   7.50  9.51         8.32
      55 active1 visit 9  subgroup3     3  7.95 0.913 0.527   6.92  8.98         8.29
      56 active1 visit 12 subgroup3     3  8.94 0.772 0.446   8.07  9.82         8.66
      57 active2 Baseline subgroup3     4 10.1  1.26  0.630   8.85 11.3          9.86
      58 active2 visit 3  subgroup3     4  8.57 0.881 0.441   7.71  9.44         8.91
      59 active2 visit 4  subgroup3     4  8.02 0.367 0.183   7.66  8.38         8.14
      60 active2 visit 5  subgroup3     4  8.21 1.05  0.526   7.18  9.24         7.73
      61 active2 visit 7  subgroup3     4  7.53 1.20  0.598   6.36  8.70         7.63
      62 active2 visit 8  subgroup3     4  7.79 1.06  0.528   6.75  8.82         7.54
      63 active2 visit 9  subgroup3     4  6.27 0.677 0.338   5.61  6.93         7.25
      64 active2 visit 12 subgroup3     4  7.22 0.916 0.458   6.32  8.12         6.81
      65 control Baseline subgroup3     3 10.1  0.874 0.504   9.06 11.0          9.86
      66 control visit 3  subgroup3     3  8.84 0.134 0.0775  8.68  8.99         9.12
      67 control visit 4  subgroup3     3  9.69 0.459 0.265   9.17 10.2          8.44
      68 control visit 5  subgroup3     3  7.14 1.27  0.736   5.70  8.59         7.91
      69 control visit 7  subgroup3     3  6.46 0.960 0.554   5.37  7.54         7.49
      70 control visit 8  subgroup3     3  6.89 0.617 0.356   6.19  7.58         7.04
      71 control visit 9  subgroup3     3  6.67 1.35  0.777   5.15  8.19         6.45
      72 control visit 12 subgroup3     3  5.61 0.897 0.518   4.60  6.63         5.76
         response_se response_df response_lower response_upper change_est change_se
               <dbl>       <dbl>          <dbl>          <dbl>      <dbl>     <dbl>
       1       0.250        27.8           9.91          10.9      NA        NA    
       2       0.231        26.8           9.19          10.1      -0.761     0.256
       3       0.325        22.7           8.37           9.72     -1.38      0.417
       4       0.316        23.3           8.06           9.37     -1.70      0.434
       5       0.366        21.3           7.92           9.44     -1.74      0.459
       6       0.418        21.2           7.91           9.64     -1.65      0.491
       7       0.270        20.2           8.31           9.44     -1.55      0.393
       8       0.500        23.2           7.93          10.00     -1.46      0.605
       9       0.250        27.8           9.91          10.9      NA        NA    
      10       0.236        24.2           8.42           9.39     -1.52      0.279
      11       0.352        22.7           7.01           8.47     -2.68      0.456
      12       0.338        23.2           6.57           7.97     -3.15      0.464
      13       0.340        20.9           6.74           8.15     -2.98      0.443
      14       0.401        21.6           6.98           8.65     -2.61      0.471
      15       0.293        19.8           7.39           8.61     -2.42      0.397
      16       0.348        21.7           7.31           8.75     -2.39      0.477
      17       0.250        27.8           9.91          10.9      NA        NA    
      18       0.201        24.1           8.73           9.56     -1.28      0.250
      19       0.292        22.0           7.44           8.66     -2.37      0.412
      20       0.287        23.3           6.73           7.92     -3.10      0.429
      21       0.297        20.5           6.35           7.59     -3.46      0.412
      22       0.351        20.6           6.06           7.51     -3.64      0.429
      23       0.258        19.3           6.08           7.15     -3.81      0.371
      24       0.301        22.0           5.80           7.05     -3.99      0.441
      25       0.255        28.6           9.48          10.5      NA        NA    
      26       0.216        26.0           8.76           9.65     -0.798     0.259
      27       0.313        23.9           8.01           9.31     -1.34      0.425
      28       0.295        24.2           8.00           9.22     -1.39      0.432
      29       0.287        22.5           8.37           9.56     -1.04      0.400
      30       0.346        23.8           8.55           9.97     -0.742     0.420
      31       0.264        21.3           8.60           9.70     -0.851     0.373
      32       0.310        22.9           8.10           9.38     -1.26      0.450
      33       0.255        28.6           9.48          10.5      NA        NA    
      34       0.223        26.4           8.74           9.65     -0.806     0.253
      35       0.314        21.5           7.93           9.23     -1.42      0.415
      36       0.311        22.2           7.69           8.98     -1.67      0.436
      37       0.356        21.2           7.65           9.13     -1.61      0.455
      38       0.413        21.5           7.56           9.28     -1.58      0.487
      39       0.280        19.7           7.57           8.74     -1.84      0.397
      40       0.412        22.2           6.82           8.53     -2.33      0.531
      41       0.255        28.6           9.48          10.5      NA        NA    
      42       0.228        24.6           7.94           8.88     -1.59      0.273
      43       0.335        21.9           6.54           7.93     -2.77      0.445
      44       0.329        23.0           6.20           7.56     -3.12      0.461
      45       0.361        20.7           6.38           7.88     -2.88      0.463
      46       0.408        20.6           6.23           7.93     -2.92      0.481
      47       0.269        19.7           5.51           6.64     -3.93      0.390
      48       0.489        22.5           3.35           5.38     -5.63      0.599
      49       0.248        28.7           9.35          10.4      NA        NA    
      50       0.229        25.3           9.64          10.6       0.251     0.259
      51       0.327        21.7           9.45          10.8       0.267     0.422
      52       0.311        22.1           9.04          10.3      -0.173     0.432
      53       0.334        21.6           8.22           9.61     -0.942     0.433
      54       0.405        22.4           7.48           9.16     -1.54      0.477
      55       0.299        19.8           7.66           8.91     -1.57      0.406
      56       0.350        21.7           7.93           9.38     -1.20      0.479
      57       0.248        28.7           9.35          10.4      NA        NA    
      58       0.204        23.9           8.49           9.33     -0.949     0.257
      59       0.302        23.2           7.52           8.77     -1.72      0.421
      60       0.287        24.4           7.14           8.32     -2.13      0.427
      61       0.284        20.6           7.03           8.22     -2.23      0.395
      62       0.340        21.5           6.84           8.25     -2.32      0.411
      63       0.252        19.6           6.73           7.78     -2.61      0.358
      64       0.328        21.9           6.13           7.49     -3.05      0.458
      65       0.248        28.7           9.35          10.4      NA        NA    
      66       0.240        25.3           8.62           9.61     -0.743     0.277
      67       0.353        23.2           7.71           9.17     -1.41      0.450
      68       0.333        24.0           7.23           8.60     -1.95      0.453
      69       0.338        22.3           6.79           8.19     -2.37      0.436
      70       0.394        22.3           6.22           7.86     -2.82      0.463
      71       0.278        20.5           5.87           7.03     -3.41      0.392
      72       0.443        23.9           4.84           6.67     -4.10      0.560
         change_df change_lower change_upper change_test_statistic change_p_value
             <dbl>        <dbl>        <dbl>                 <dbl>          <dbl>
       1      NA         NA          NA                     NA          NA       
       2      35.3       -1.28       -0.241                 -2.97        5.33e- 3
       3      36.6       -2.22       -0.531                 -3.30        2.16e- 3
       4      37.9       -2.58       -0.826                 -3.93        3.51e- 4
       5      34.2       -2.68       -0.811                 -3.80        5.73e- 4
       6      30.5       -2.65       -0.646                 -3.36        2.13e- 3
       7      36.0       -2.35       -0.751                 -3.94        3.62e- 4
       8      34.0       -2.69       -0.231                 -2.41        2.13e- 2
       9      NA         NA          NA                     NA          NA       
      10      35.7       -2.08       -0.949                 -5.43        4.13e- 6
      11      36.3       -3.60       -1.76                  -5.88        9.88e- 7
      12      36.4       -4.09       -2.21                  -6.79        5.86e- 8
      13      33.7       -3.88       -2.08                  -6.72        1.08e- 7
      14      29.8       -3.57       -1.65                  -5.54        5.16e- 6
      15      32.7       -3.23       -1.61                  -6.09        7.53e- 7
      16      35.1       -3.36       -1.43                  -5.02        1.50e- 5
      17      NA         NA          NA                     NA          NA       
      18      36.3       -1.79       -0.772                 -5.12        1.03e- 5
      19      37.0       -3.21       -1.54                  -5.75        1.34e- 6
      20      37.1       -3.97       -2.23                  -7.22        1.41e- 8
      21      34.1       -4.29       -2.62                  -8.39        8.37e-10
      22      29.9       -4.51       -2.76                  -8.47        1.92e- 9
      23      32.3       -4.56       -3.05                 -10.3         1.09e-11
      24      34.9       -4.89       -3.10                  -9.05        1.13e-10
      25      NA         NA          NA                     NA          NA       
      26      34.2       -1.32       -0.271                 -3.08        4.10e- 3
      27      34.0       -2.21       -0.480                 -3.16        3.29e- 3
      28      33.1       -2.27       -0.514                 -3.23        2.83e- 3
      29      31.7       -1.86       -0.225                 -2.60        1.40e- 2
      30      29.6       -1.60        0.117                 -1.76        8.81e- 2
      31      30.7       -1.61       -0.0899                -2.28        2.96e- 2
      32      33.6       -2.18       -0.348                 -2.81        8.27e- 3
      33      NA         NA          NA                     NA          NA       
      34      35.5       -1.32       -0.293                 -3.18        3.02e- 3
      35      36.8       -2.26       -0.582                 -3.43        1.50e- 3
      36      38.3       -2.55       -0.786                 -3.83        4.65e- 4
      37      35.5       -2.53       -0.686                 -3.54        1.15e- 3
      38      31.6       -2.57       -0.587                 -3.24        2.79e- 3
      39      35.7       -2.65       -1.04                  -4.64        4.53e- 5
      40      35.0       -3.41       -1.25                  -4.38        1.03e- 4
      41      NA         NA          NA                     NA          NA       
      42      38.0       -2.15       -1.04                  -5.85        9.13e- 7
      43      39.7       -3.67       -1.87                  -6.22        2.43e- 7
      44      41.1       -4.05       -2.19                  -6.78        3.38e- 8
      45      35.8       -3.81       -1.94                  -6.22        3.65e- 7
      46      30.8       -3.90       -1.94                  -6.07        1.04e- 6
      47      36.5       -4.72       -3.14                 -10.1         4.38e-12
      48      35.0       -6.85       -4.42                  -9.41        4.04e-11
      49      NA         NA          NA                     NA          NA       
      50      34.6       -0.275       0.777                  0.968       3.40e- 1
      51      35.5       -0.589       1.12                   0.633       5.31e- 1
      52      36.4       -1.05        0.703                 -0.400       6.92e- 1
      53      34.6       -1.82       -0.0622                -2.17        3.66e- 2
      54      30.8       -2.51       -0.564                 -3.22        3.00e- 3
      55      33.3       -2.40       -0.746                 -3.87        4.80e- 4
      56      35.8       -2.18       -0.232                 -2.51        1.66e- 2
      57      NA         NA          NA                     NA          NA       
      58      40.7       -1.47       -0.430                 -3.69        6.52e- 4
      59      41.4       -2.57       -0.868                 -4.08        1.99e- 4
      60      41.2       -2.99       -1.27                  -4.98        1.17e- 5
      61      35.7       -3.04       -1.43                  -5.65        2.08e- 6
      62      29.9       -3.16       -1.48                  -5.65        3.80e- 6
      63      32.6       -3.33       -1.88                  -7.28        2.52e- 8
      64      36.3       -3.98       -2.12                  -6.67        8.60e- 8
      65      NA         NA          NA                     NA          NA       
      66      35.4       -1.31       -0.181                 -2.68        1.11e- 2
      67      36.4       -2.33       -0.503                 -3.14        3.31e- 3
      68      37.7       -2.86       -1.03                  -4.30        1.17e- 4
      69      35.5       -3.25       -1.48                  -5.43        4.14e- 6
      70      31.0       -3.76       -1.87                  -6.09        9.63e- 7
      71      34.9       -4.20       -2.61                  -8.70        2.88e-10
      72      35.5       -5.24       -2.96                  -7.33        1.34e- 8
         diff_arm_est diff_arm_se diff_arm_df diff_arm_lower diff_arm_upper
                <dbl>       <dbl>       <dbl>          <dbl>          <dbl>
       1      NA           NA            NA          NA              NA    
       2       0.518        0.279        22.4        -0.0604          1.10 
       3       0.995        0.438        22.4         0.0889          1.90 
       4       1.39         0.420        21.9         0.522           2.27 
       5       1.71         0.472        21.0         0.731           2.69 
       6       1.99         0.547        21.4         0.851           3.13 
       7       2.26         0.374        20.3         1.48            3.04 
       8       2.53         0.571        22.1         1.35            3.72 
       9      NA           NA            NA          NA              NA    
      10      -0.237        0.288        21.7        -0.834           0.361
      11      -0.308        0.453        21.5        -1.25            0.633
      12      -0.0550       0.428        21.0        -0.946           0.836
      13       0.479        0.447        20.2        -0.454           1.41 
      14       1.03         0.531        21.2        -0.0751          2.13 
      15       1.39         0.389        19.4         0.576           2.20 
      16       1.60         0.444        19.8         0.673           2.53 
      17      NA           NA            NA          NA              NA    
      18      NA           NA            NA          NA              NA    
      19      NA           NA            NA          NA              NA    
      20      NA           NA            NA          NA              NA    
      21      NA           NA            NA          NA              NA    
      22      NA           NA            NA          NA              NA    
      23      NA           NA            NA          NA              NA    
      24      NA           NA            NA          NA              NA    
      25      NA           NA            NA          NA              NA    
      26       0.796        0.291        23.0         0.194           1.40 
      27       1.43         0.457        22.8         0.479           2.37 
      28       1.73         0.433        22.1         0.833           2.63 
      29       1.84         0.461        21.6         0.879           2.79 
      30       2.18         0.535        22.5         1.07            3.29 
      31       3.08         0.378        20.9         2.29            3.86 
      32       4.37         0.567        22.0         3.20            5.55 
      33      NA           NA            NA          NA              NA    
      34       0.788        0.293        21.9         0.180           1.40 
      35       1.35         0.460        21.8         0.391           2.30 
      36       1.45         0.446        21.4         0.527           2.38 
      37       1.27         0.507        20.9         0.212           2.32 
      38       1.34         0.582        21.4         0.129           2.55 
      39       2.08         0.389        20.1         1.27            2.90 
      40       3.31         0.627        21.2         2.00            4.61 
      41      NA           NA            NA          NA              NA    
      42      NA           NA            NA          NA              NA    
      43      NA           NA            NA          NA              NA    
      44      NA           NA            NA          NA              NA    
      45      NA           NA            NA          NA              NA    
      46      NA           NA            NA          NA              NA    
      47      NA           NA            NA          NA              NA    
      48      NA           NA            NA          NA              NA    
      49      NA           NA            NA          NA              NA    
      50       0.994        0.308        22.8         0.358           1.63 
      51       1.68         0.481        22.6         0.685           2.68 
      52       1.77         0.450        22.1         0.840           2.71 
      53       1.42         0.477        22.0         0.435           2.41 
      54       1.28         0.568        22.7         0.106           2.46 
      55       1.84         0.411        20.5         0.983           2.69 
      56       2.90         0.549        21.6         1.76            4.04 
      57      NA           NA            NA          NA              NA    
      58      -0.206        0.297        23.2        -0.819           0.407
      59      -0.302        0.465        23.2        -1.26            0.659
      60      -0.184        0.433        22.8        -1.08            0.711
      61       0.133        0.444        21.8        -0.788           1.05 
      62       0.502        0.523        22.3        -0.582           1.59 
      63       0.803        0.379        20.8         0.0143          1.59 
      64       1.05         0.539        22.1        -0.0714          2.17 
      65      NA           NA            NA          NA              NA    
      66      NA           NA            NA          NA              NA    
      67      NA           NA            NA          NA              NA    
      68      NA           NA            NA          NA              NA    
      69      NA           NA            NA          NA              NA    
      70      NA           NA            NA          NA              NA    
      71      NA           NA            NA          NA              NA    
      72      NA           NA            NA          NA              NA    
         diff_arm_test_statistic diff_arm_p_value percent_slowing_est
                           <dbl>            <dbl>               <dbl>
       1                  NA        NA                          NA   
       2                   1.86      0.0768                     40.5 
       3                   2.28      0.0328                     42.0 
       4                   3.32      0.00315                    45.0 
       5                   3.63      0.00157                    49.5 
       6                   3.63      0.00153                    54.7 
       7                   6.04      0.00000618                 59.3 
       8                   4.44      0.000205                   63.4 
       9                  NA        NA                          NA   
      10                  -0.823     0.420                     -18.5 
      11                  -0.680     0.504                     -13.0 
      12                  -0.128     0.899                      -1.77
      13                   1.07      0.297                      13.8 
      14                   1.94      0.0662                     28.3 
      15                   3.57      0.00198                    36.5 
      16                   3.60      0.00180                    40.1 
      17                  NA        NA                          NA   
      18                  NA        NA                          NA   
      19                  NA        NA                          NA   
      20                  NA        NA                          NA   
      21                  NA        NA                          NA   
      22                  NA        NA                          NA   
      23                  NA        NA                          NA   
      24                  NA        NA                          NA   
      25                  NA        NA                          NA   
      26                   2.73      0.0118                     50.0 
      27                   3.12      0.00486                    51.5 
      28                   4.00      0.000604                   55.4 
      29                   3.98      0.000647                   63.8 
      30                   4.07      0.000492                   74.6 
      31                   8.15      0.0000000628               78.3 
      32                   7.72      0.000000106                77.6 
      33                  NA        NA                          NA   
      34                   2.69      0.0135                     49.4 
      35                   2.92      0.00791                    48.6 
      36                   3.26      0.00370                    46.6 
      37                   2.50      0.0209                     44.1 
      38                   2.30      0.0317                     45.9 
      39                   5.36      0.0000302                  53.1 
      40                   5.28      0.0000304                  58.7 
      41                  NA        NA                          NA   
      42                  NA        NA                          NA   
      43                  NA        NA                          NA   
      44                  NA        NA                          NA   
      45                  NA        NA                          NA   
      46                  NA        NA                          NA   
      47                  NA        NA                          NA   
      48                  NA        NA                          NA   
      49                  NA        NA                          NA   
      50                   3.23      0.00371                   134.  
      51                   3.49      0.00199                   119.  
      52                   3.94      0.000693                   91.1 
      53                   2.99      0.00680                    60.2 
      54                   2.26      0.0340                     45.5 
      55                   4.48      0.000219                   53.9 
      56                   5.27      0.0000290                  70.6 
      57                  NA        NA                          NA   
      58                  -0.694     0.494                     -27.7 
      59                  -0.650     0.522                     -21.4 
      60                  -0.426     0.674                      -9.48
      61                   0.299     0.768                       5.60
      62                   0.960     0.347                      17.8 
      63                   2.12      0.0463                     23.6 
      64                   1.94      0.0651                     25.5 
      65                  NA        NA                          NA   
      66                  NA        NA                          NA   
      67                  NA        NA                          NA   
      68                  NA        NA                          NA   
      69                  NA        NA                          NA   
      70                  NA        NA                          NA   
      71                  NA        NA                          NA   
      72                  NA        NA                          NA   
         percent_slowing_lower percent_slowing_upper correlation               
                         <dbl>                 <dbl> <chr>                     
       1                 NA                     NA   heterogeneous unstructured
       2                 -4.93                  85.9 heterogeneous unstructured
       3                  2.24                  81.7 heterogeneous unstructured
       4                 13.7                   76.2 heterogeneous unstructured
       5                 20.9                   78.1 heterogeneous unstructured
       6                 26.2                   83.1 heterogeneous unstructured
       7                 37.7                   81.0 heterogeneous unstructured
       8                 32.7                   94.1 heterogeneous unstructured
       9                 NA                     NA   heterogeneous unstructured
      10                -80.9                   43.9 heterogeneous unstructured
      11                -66.8                   40.9 heterogeneous unstructured
      12                -42.1                   38.6 heterogeneous unstructured
      13                -18.4                   46.1 heterogeneous unstructured
      14                 -2.00                  58.6 heterogeneous unstructured
      15                 12.7                   60.2 heterogeneous unstructured
      16                 13.3                   66.8 heterogeneous unstructured
      17                 NA                     NA   heterogeneous unstructured
      18                 NA                     NA   heterogeneous unstructured
      19                 NA                     NA   heterogeneous unstructured
      20                 NA                     NA   heterogeneous unstructured
      21                 NA                     NA   heterogeneous unstructured
      22                 NA                     NA   heterogeneous unstructured
      23                 NA                     NA   heterogeneous unstructured
      24                 NA                     NA   heterogeneous unstructured
      25                 NA                     NA   heterogeneous unstructured
      26                 13.9                   86.0 heterogeneous unstructured
      27                 17.8                   85.2 heterogeneous unstructured
      28                 25.4                   85.4 heterogeneous unstructured
      29                 34.3                   93.4 heterogeneous unstructured
      30                 45.2                  104.  heterogeneous unstructured
      31                 59.3                   97.4 heterogeneous unstructured
      32                 61.3                   93.9 heterogeneous unstructured
      33                 NA                     NA   heterogeneous unstructured
      34                 14.0                   84.9 heterogeneous unstructured
      35                 15.1                   82.1 heterogeneous unstructured
      36                 15.2                   78.0 heterogeneous unstructured
      37                  8.42                  79.7 heterogeneous unstructured
      38                  8.77                  83.0 heterogeneous unstructured
      39                 31.2                   74.9 heterogeneous unstructured
      40                 38.3                   79.1 heterogeneous unstructured
      41                 NA                     NA   heterogeneous unstructured
      42                 NA                     NA   heterogeneous unstructured
      43                 NA                     NA   heterogeneous unstructured
      44                 NA                     NA   heterogeneous unstructured
      45                 NA                     NA   heterogeneous unstructured
      46                 NA                     NA   heterogeneous unstructured
      47                 NA                     NA   heterogeneous unstructured
      48                 NA                     NA   heterogeneous unstructured
      49                 NA                     NA   heterogeneous unstructured
      50                 61.1                  206.  heterogeneous unstructured
      51                 59.3                  178.  heterogeneous unstructured
      52                 47.5                  135.  heterogeneous unstructured
      53                 21.5                   98.8 heterogeneous unstructured
      54                  7.97                  83.0 heterogeneous unstructured
      55                 28.4                   79.4 heterogeneous unstructured
      56                 46.4                   94.8 heterogeneous unstructured
      57                 NA                     NA   heterogeneous unstructured
      58               -143.                    87.6 heterogeneous unstructured
      59               -117.                    74.1 heterogeneous unstructured
      60                -75.4                   56.5 heterogeneous unstructured
      61                -41.6                   52.8 heterogeneous unstructured
      62                -21.1                   56.7 heterogeneous unstructured
      63                 -3.26                  50.4 heterogeneous unstructured
      64                 -4.05                  55.1 heterogeneous unstructured
      65                 NA                     NA   heterogeneous unstructured
      66                 NA                     NA   heterogeneous unstructured
      67                 NA                     NA   heterogeneous unstructured
      68                 NA                     NA   heterogeneous unstructured
      69                 NA                     NA   heterogeneous unstructured
      70                 NA                     NA   heterogeneous unstructured
      71                 NA                     NA   heterogeneous unstructured
      72                 NA                     NA   heterogeneous unstructured
         optimizer
         <chr>    
       1 mmrm+tmb 
       2 mmrm+tmb 
       3 mmrm+tmb 
       4 mmrm+tmb 
       5 mmrm+tmb 
       6 mmrm+tmb 
       7 mmrm+tmb 
       8 mmrm+tmb 
       9 mmrm+tmb 
      10 mmrm+tmb 
      11 mmrm+tmb 
      12 mmrm+tmb 
      13 mmrm+tmb 
      14 mmrm+tmb 
      15 mmrm+tmb 
      16 mmrm+tmb 
      17 mmrm+tmb 
      18 mmrm+tmb 
      19 mmrm+tmb 
      20 mmrm+tmb 
      21 mmrm+tmb 
      22 mmrm+tmb 
      23 mmrm+tmb 
      24 mmrm+tmb 
      25 mmrm+tmb 
      26 mmrm+tmb 
      27 mmrm+tmb 
      28 mmrm+tmb 
      29 mmrm+tmb 
      30 mmrm+tmb 
      31 mmrm+tmb 
      32 mmrm+tmb 
      33 mmrm+tmb 
      34 mmrm+tmb 
      35 mmrm+tmb 
      36 mmrm+tmb 
      37 mmrm+tmb 
      38 mmrm+tmb 
      39 mmrm+tmb 
      40 mmrm+tmb 
      41 mmrm+tmb 
      42 mmrm+tmb 
      43 mmrm+tmb 
      44 mmrm+tmb 
      45 mmrm+tmb 
      46 mmrm+tmb 
      47 mmrm+tmb 
      48 mmrm+tmb 
      49 mmrm+tmb 
      50 mmrm+tmb 
      51 mmrm+tmb 
      52 mmrm+tmb 
      53 mmrm+tmb 
      54 mmrm+tmb 
      55 mmrm+tmb 
      56 mmrm+tmb 
      57 mmrm+tmb 
      58 mmrm+tmb 
      59 mmrm+tmb 
      60 mmrm+tmb 
      61 mmrm+tmb 
      62 mmrm+tmb 
      63 mmrm+tmb 
      64 mmrm+tmb 
      65 mmrm+tmb 
      66 mmrm+tmb 
      67 mmrm+tmb 
      68 mmrm+tmb 
      69 mmrm+tmb 
      70 mmrm+tmb 
      71 mmrm+tmb 
      72 mmrm+tmb 

---

    Code
      print(test_ncs_analysis_subgroup$type3, width = Inf, n = Inf)
    Output
      # A tibble: 15 x 6
         effect                                     chisquare_test_statistic    df
         <chr>                                                         <dbl> <int>
       1 spline_fn(time_obs_cont)[, 1]                                23.3       1
       2 spline_fn(time_obs_cont)[, 2]                               121.        1
       3 spline_fn(time_obs_cont)[, 3]                                67.1       1
       4 subgroup                                                      2.75      2
       5 categorical2                                                  0.552     1
       6 continuous1                                                   0.779     1
       7 spline_fn(time_obs_cont)[, 1]:subgroup                        7.43      2
       8 spline_fn(time_obs_cont)[, 2]:subgroup                        2.50      2
       9 spline_fn(time_obs_cont)[, 3]:subgroup                        7.62      2
      10 spline_fn(time_obs_cont)[, 1]:arm                             1.62      2
      11 spline_fn(time_obs_cont)[, 2]:arm                           121.        2
      12 spline_fn(time_obs_cont)[, 3]:arm                            32.4       2
      13 spline_fn(time_obs_cont)[, 1]:subgroup:arm                    2.70      4
      14 spline_fn(time_obs_cont)[, 2]:subgroup:arm                   22.1       4
      15 spline_fn(time_obs_cont)[, 3]:subgroup:arm                    3.76      4
          p_value correlation                optimizer
            <dbl> <chr>                      <chr>    
       1 1.40e- 6 heterogeneous unstructured mmrm+tmb 
       2 3.11e-28 heterogeneous unstructured mmrm+tmb 
       3 2.53e-16 heterogeneous unstructured mmrm+tmb 
       4 2.53e- 1 heterogeneous unstructured mmrm+tmb 
       5 4.58e- 1 heterogeneous unstructured mmrm+tmb 
       6 3.77e- 1 heterogeneous unstructured mmrm+tmb 
       7 2.43e- 2 heterogeneous unstructured mmrm+tmb 
       8 2.87e- 1 heterogeneous unstructured mmrm+tmb 
       9 2.21e- 2 heterogeneous unstructured mmrm+tmb 
      10 4.45e- 1 heterogeneous unstructured mmrm+tmb 
      11 4.19e-27 heterogeneous unstructured mmrm+tmb 
      12 9.10e- 8 heterogeneous unstructured mmrm+tmb 
      13 6.08e- 1 heterogeneous unstructured mmrm+tmb 
      14 1.90e- 4 heterogeneous unstructured mmrm+tmb 
      15 4.39e- 1 heterogeneous unstructured mmrm+tmb 

---

    Code
      print(test_ncs_analysis_subgroup$interaction)
    Output
                model      aic      bic    loglik -2*log(l) test_statistic df
      1 reduced model 753.6110 832.0781 -320.8055  641.6110             NA NA
      2    full model 752.3135 847.5949 -308.1567  616.3135       25.29759 12
           p_value                correlation optimizer
      1         NA heterogeneous unstructured  mmrm+tmb
      2 0.01347395 heterogeneous unstructured  mmrm+tmb

# splinetrials_analysis_base() works

    Code
      print(test_splinetrials_analysis_base_actual$response_stats_tbl, width = Inf,
      n = Inf)
    Output
      # A tibble: 72 x 10
         arm     time     time_num subgroup      n   est    sd     se lower upper
         <fct>   <chr>       <dbl> <fct>     <int> <dbl> <dbl>  <dbl> <dbl> <dbl>
       1 active1 Baseline     0    subgroup1     3 10.5  0.374 0.216  10.1  10.9 
       2 active1 Baseline     0    subgroup2     4 10.8  1.31  0.654   9.48 12.0 
       3 active1 Baseline     0    subgroup3     3  9.83 0.522 0.301   9.24 10.4 
       4 active1 visit 3      0.25 subgroup1     3  9.50 0.284 0.164   9.18  9.82
       5 active1 visit 3      0.25 subgroup2     4  8.87 0.849 0.425   8.03  9.70
       6 active1 visit 3      0.25 subgroup3     3  9.87 0.637 0.368   9.15 10.6 
       7 active1 visit 4      0.5  subgroup1     3  9.49 0.598 0.345   8.81 10.2 
       8 active1 visit 4      0.5  subgroup2     4  9.26 1.18  0.590   8.10 10.4 
       9 active1 visit 4      0.5  subgroup3     3  9.98 1.43  0.828   8.36 11.6 
      10 active1 visit 5      0.75 subgroup1     3  8.27 0.703 0.406   7.47  9.06
      11 active1 visit 5      0.75 subgroup2     4  9.07 0.280 0.140   8.80  9.35
      12 active1 visit 5      0.75 subgroup3     3  9.67 0.550 0.317   9.05 10.3 
      13 active1 visit 7      1    subgroup1     3  8.53 0.800 0.462   7.63  9.44
      14 active1 visit 7      1    subgroup2     4  8.35 1.10  0.548   7.28  9.43
      15 active1 visit 7      1    subgroup3     3  9.99 1.14  0.661   8.70 11.3 
      16 active1 visit 8      1.25 subgroup1     3  8.78 0.923 0.533   7.73  9.82
      17 active1 visit 8      1.25 subgroup2     4  8.64 0.500 0.250   8.15  9.13
      18 active1 visit 8      1.25 subgroup3     3  8.51 0.889 0.513   7.50  9.51
      19 active1 visit 9      1.5  subgroup1     3  8.99 0.128 0.0737  8.84  9.13
      20 active1 visit 9      1.5  subgroup2     4  9.33 0.828 0.414   8.52 10.1 
      21 active1 visit 9      1.5  subgroup3     3  7.95 0.913 0.527   6.92  8.98
      22 active1 visit 12     1.75 subgroup1     3  8.91 0.386 0.223   8.47  9.34
      23 active1 visit 12     1.75 subgroup2     4  8.14 0.938 0.469   7.22  9.06
      24 active1 visit 12     1.75 subgroup3     3  8.94 0.772 0.446   8.07  9.82
      25 active2 Baseline     0    subgroup1     3 10.6  1.41  0.816   8.99 12.2 
      26 active2 Baseline     0    subgroup2     3 10.5  2.06  1.19    8.12 12.8 
      27 active2 Baseline     0    subgroup3     4 10.1  1.26  0.630   8.85 11.3 
      28 active2 visit 3      0.25 subgroup1     3  8.90 1.71  0.985   6.97 10.8 
      29 active2 visit 3      0.25 subgroup2     3  9.89 1.06  0.612   8.69 11.1 
      30 active2 visit 3      0.25 subgroup3     4  8.57 0.881 0.441   7.71  9.44
      31 active2 visit 4      0.5  subgroup1     3  7.83 1.24  0.715   6.43  9.23
      32 active2 visit 4      0.5  subgroup2     3  7.96 1.25  0.721   6.55  9.37
      33 active2 visit 4      0.5  subgroup3     4  8.02 0.367 0.183   7.66  8.38
      34 active2 visit 5      0.75 subgroup1     3  7.66 0.284 0.164   7.34  7.98
      35 active2 visit 5      0.75 subgroup2     3  8.48 2.81  1.62    5.30 11.7 
      36 active2 visit 5      0.75 subgroup3     4  8.21 1.05  0.526   7.18  9.24
      37 active2 visit 7      1    subgroup1     3  8.05 1.48  0.857   6.37  9.73
      38 active2 visit 7      1    subgroup2     3  8.35 0.403 0.233   7.89  8.81
      39 active2 visit 7      1    subgroup3     4  7.53 1.20  0.598   6.36  8.70
      40 active2 visit 8      1.25 subgroup1     3  7.40 1.28  0.739   5.95  8.85
      41 active2 visit 8      1.25 subgroup2     3  8.97 1.22  0.702   7.60 10.3 
      42 active2 visit 8      1.25 subgroup3     4  7.79 1.06  0.528   6.75  8.82
      43 active2 visit 9      1.5  subgroup1     3  8.11 0.822 0.474   7.18  9.04
      44 active2 visit 9      1.5  subgroup2     3  8.01 1.31  0.757   6.53  9.50
      45 active2 visit 9      1.5  subgroup3     4  6.27 0.677 0.338   5.61  6.93
      46 active2 visit 12     1.75 subgroup1     3  7.96 0.292 0.169   7.63  8.29
      47 active2 visit 12     1.75 subgroup2     3  7.66 0.917 0.530   6.62  8.70
      48 active2 visit 12     1.75 subgroup3     4  7.22 0.916 0.458   6.32  8.12
      49 control Baseline     0    subgroup1     4 10.3  0.252 0.126  10.0  10.5 
      50 control Baseline     0    subgroup2     3  9.26 0.825 0.476   8.33 10.2 
      51 control Baseline     0    subgroup3     3 10.1  0.874 0.504   9.06 11.0 
      52 control visit 3      0.25 subgroup1     4  8.84 1.13  0.564   7.73  9.94
      53 control visit 3      0.25 subgroup2     3  7.43 2.23  1.29    4.91  9.95
      54 control visit 3      0.25 subgroup3     3  8.84 0.134 0.0775  8.68  8.99
      55 control visit 4      0.5  subgroup1     4  8.32 0.933 0.467   7.41  9.24
      56 control visit 4      0.5  subgroup2     3  7.19 0.366 0.211   6.77  7.60
      57 control visit 4      0.5  subgroup3     3  9.69 0.459 0.265   9.17 10.2 
      58 control visit 5      0.75 subgroup1     4  7.26 1.15  0.576   6.13  8.39
      59 control visit 5      0.75 subgroup2     3  8.11 0.724 0.418   7.30  8.93
      60 control visit 5      0.75 subgroup3     3  7.14 1.27  0.736   5.70  8.59
      61 control visit 7      1    subgroup1     4  7.29 1.28  0.641   6.03  8.55
      62 control visit 7      1    subgroup2     3  7.18 1.38  0.795   5.62  8.74
      63 control visit 7      1    subgroup3     3  6.46 0.960 0.554   5.37  7.54
      64 control visit 8      1.25 subgroup1     4  6.60 0.977 0.489   5.64  7.56
      65 control visit 8      1.25 subgroup2     3  6.99 1.08  0.624   5.77  8.21
      66 control visit 8      1.25 subgroup3     3  6.89 0.617 0.356   6.19  7.58
      67 control visit 9      1.5  subgroup1     4  6.66 1.52  0.759   5.18  8.15
      68 control visit 9      1.5  subgroup2     3  5.45 0.809 0.467   4.53  6.36
      69 control visit 9      1.5  subgroup3     3  6.67 1.35  0.777   5.15  8.19
      70 control visit 12     1.75 subgroup1     4  6.33 1.52  0.760   4.84  7.82
      71 control visit 12     1.75 subgroup2     3  5.35 0.796 0.459   4.45  6.25
      72 control visit 12     1.75 subgroup3     3  5.61 0.897 0.518   4.60  6.63

---

    Code
      print(test_splinetrials_analysis_base_actual$emmeans_tbl, width = Inf, n = Inf)
    Output
       arm     time_num subgroup  response_est response_se response_df response_lower
       control     0.00 subgroup1    10.422379   0.2504131    27.75628       9.909228
       active1     0.00 subgroup1    10.422379   0.2504131    27.75628       9.909228
       active2     0.00 subgroup1    10.422379   0.2504131    27.75628       9.909228
       control     0.25 subgroup1     9.143193   0.2007449    24.07533       8.728944
       active1     0.25 subgroup1     9.661054   0.2311152    26.76176       9.186647
       active2     0.25 subgroup1     8.906417   0.2360679    24.22143       8.419433
       control     0.50 subgroup1     8.050548   0.2924755    22.00930       7.444006
       active1     0.50 subgroup1     9.045927   0.3245640    22.67431       8.373981
       active2     0.50 subgroup1     7.742698   0.3517731    22.69564       7.014459
       control     0.75 subgroup1     7.324412   0.2868327    23.31076       6.731491
       active1     0.75 subgroup1     8.718015   0.3162098    23.28864       8.064334
       active2     0.75 subgroup1     7.269442   0.3380712    23.17074       6.570374
       control     1.00 subgroup1     6.966709   0.2970793    20.52265       6.348022
       active1     1.00 subgroup1     8.678047   0.3657401    21.26083       7.918016
       active2     1.00 subgroup1     7.445249   0.3403670    20.89057       6.737191
       control     1.25 subgroup1     6.785024   0.3505282    20.59979       6.055197
       active1     1.25 subgroup1     8.773619   0.4176302    21.23908       7.905704
       active2     1.25 subgroup1     7.814345   0.4010711    21.64710       6.981787
       control     1.50 subgroup1     6.613741   0.2575025    19.25473       6.075264
       active1     1.50 subgroup1     8.873864   0.2698410    20.19297       8.311330
       active2     1.50 subgroup1     8.002265   0.2934208    19.76771       7.389738
       control     1.75 subgroup1     6.428662   0.3011668    21.98841       5.804061
       active1     1.75 subgroup1     8.960961   0.5003608    23.16688       7.926298
       active2     1.75 subgroup1     8.029351   0.3482102    21.73737       7.306701
       control     0.00 subgroup2    10.002019   0.2546427    28.64389       9.480935
       active1     0.00 subgroup2    10.002019   0.2546427    28.64389       9.480935
       active2     0.00 subgroup2    10.002019   0.2546427    28.64389       9.480935
       control     0.25 subgroup2     8.407770   0.2275476    24.62417       7.938764
       active1     0.25 subgroup2     9.204132   0.2163213    25.95932       8.759444
       active2     0.25 subgroup2     9.195712   0.2232194    26.41791       8.737230
       control     0.50 subgroup2     7.234316   0.3345369    21.92789       6.540397
       active1     0.50 subgroup2     8.659605   0.3127440    23.91457       8.014011
       active2     0.50 subgroup2     8.579424   0.3140224    21.52433       7.927346
       control     0.75 subgroup2     6.879704   0.3286330    23.03293       6.199928
       active1     0.75 subgroup2     8.609489   0.2954987    24.17935       7.999848
       active2     0.75 subgroup2     8.334051   0.3108433    22.19272       7.689726
       control     1.00 subgroup2     7.126094   0.3607815    20.68101       6.375103
       active1     1.00 subgroup2     8.961681   0.2872961    22.53913       8.366690
       active2     1.00 subgroup2     8.393484   0.3562196    21.16162       7.653029
       control     1.25 subgroup2     7.083395   0.4076020    20.57015       6.234661
       active1     1.25 subgroup2     9.260426   0.3456995    23.82253       8.546656
       active2     1.25 subgroup2     8.421997   0.4132667    21.47815       7.563725
       control     1.50 subgroup2     6.073443   0.2690959    19.70237       5.511574
       active1     1.50 subgroup2     9.150944   0.2639315    21.28466       8.602516
       active2     1.50 subgroup2     8.157573   0.2796350    19.71479       7.573723
       control     1.75 subgroup2     4.367426   0.4892438    22.53240       3.354185
       active1     1.75 subgroup2     8.739252   0.3104796    22.94893       8.096897
       active2     1.75 subgroup2     7.675373   0.4117716    22.18586       6.821825
       control     0.00 subgroup3     9.859804   0.2478177    28.72186       9.352746
       active1     0.00 subgroup3     9.859804   0.2478177    28.72186       9.352746
       active2     0.00 subgroup3     9.859804   0.2478177    28.72186       9.352746
       control     0.25 subgroup3     9.116350   0.2403146    25.34267       8.621752
       active1     0.25 subgroup3    10.110638   0.2293254    25.27022       9.638590
       active2     0.25 subgroup3     8.910423   0.2044186    23.90075       8.488430
       control     0.50 subgroup3     8.444979   0.3530356    23.18211       7.714986
       active1     0.50 subgroup3    10.126987   0.3269110    21.73430       9.448534
       active2     0.50 subgroup3     8.142575   0.3018389    23.15104       7.518399
       control     0.75 subgroup3     7.914095   0.3329235    24.01195       7.226993
       active1     0.75 subgroup3     9.687205   0.3107594    22.09601       9.042892
       active2     0.75 subgroup3     7.729670   0.2867657    24.40019       7.138328
       control     1.00 subgroup3     7.492571   0.3383138    22.26215       6.791430
       active1     1.00 subgroup3     8.917339   0.3339295    21.56443       8.224000
       active2     1.00 subgroup3     7.625160   0.2840232    20.64391       7.033880
       control     1.25 subgroup3     7.040635   0.3940375    22.29957       6.224087
       active1     1.25 subgroup3     8.322950   0.4054550    22.41712       7.482994
       active2     1.25 subgroup3     7.542402   0.3399323    21.52281       6.836518
       control     1.50 subgroup3     6.450600   0.2784433    20.47901       5.870647
       active1     1.50 subgroup3     8.288326   0.2991447    19.77703       7.663870
       active2     1.50 subgroup3     7.253850   0.2515137    19.58713       6.728492
       control     1.75 subgroup3     5.759847   0.4432434    23.91696       4.844870
       active1     1.75 subgroup3     8.655519   0.3504537    21.74776       7.928234
       active2     1.75 subgroup3     6.806955   0.3275126    21.92147       6.127594
       response_upper
            10.935530
            10.935530
            10.935530
             9.557441
            10.135461
             9.393402
             8.657090
             9.717873
             8.470936
             7.917333
             9.371697
             7.968511
             7.585395
             9.438077
             8.153307
             7.514850
             9.641533
             8.646902
             7.152218
             9.436398
             8.614791
             7.053263
             9.995624
             8.752001
            10.523103
            10.523103
            10.523103
             8.876776
             9.648821
             9.654193
             7.928236
             9.305198
             9.231502
             7.559479
             9.219129
             8.978376
             7.877086
             9.556671
             9.133938
             7.932130
             9.974196
             9.280268
             6.635311
             9.699373
             8.741423
             5.380668
             9.381607
             8.528920
            10.366861
            10.366861
            10.366861
             9.610948
            10.582687
             9.332415
             9.174971
            10.805440
             8.766751
             8.601197
            10.331518
             8.321013
             8.193712
             9.610679
             8.216439
             7.857183
             9.162906
             8.248286
             7.030553
             8.912782
             7.779209
             6.674825
             9.382805
             7.486316
      
      Results are averaged over the levels of: 2 nuisance factors, time_observed_index 
      Confidence level used: 0.95 

---

    Code
      print(test_splinetrials_analysis_base_actual$change_from_bl_tbl, width = Inf,
      n = Inf)
    Output
      # A tibble: 63 x 10
         arm     time_num subgroup  change_est change_se change_df change_lower
         <fct>      <dbl> <fct>          <dbl>     <dbl>     <dbl>        <dbl>
       1 control     0.25 subgroup1     -1.28      0.250      36.3       -1.79 
       2 active1     0.25 subgroup1     -0.761     0.256      35.3       -1.28 
       3 active2     0.25 subgroup1     -1.52      0.279      35.7       -2.08 
       4 control     0.5  subgroup1     -2.37      0.412      37.0       -3.21 
       5 active1     0.5  subgroup1     -1.38      0.417      36.6       -2.22 
       6 active2     0.5  subgroup1     -2.68      0.456      36.3       -3.60 
       7 control     0.75 subgroup1     -3.10      0.429      37.1       -3.97 
       8 active1     0.75 subgroup1     -1.70      0.434      37.9       -2.58 
       9 active2     0.75 subgroup1     -3.15      0.464      36.4       -4.09 
      10 control     1    subgroup1     -3.46      0.412      34.1       -4.29 
      11 active1     1    subgroup1     -1.74      0.459      34.2       -2.68 
      12 active2     1    subgroup1     -2.98      0.443      33.7       -3.88 
      13 control     1.25 subgroup1     -3.64      0.429      29.9       -4.51 
      14 active1     1.25 subgroup1     -1.65      0.491      30.5       -2.65 
      15 active2     1.25 subgroup1     -2.61      0.471      29.8       -3.57 
      16 control     1.5  subgroup1     -3.81      0.371      32.3       -4.56 
      17 active1     1.5  subgroup1     -1.55      0.393      36.0       -2.35 
      18 active2     1.5  subgroup1     -2.42      0.397      32.7       -3.23 
      19 control     1.75 subgroup1     -3.99      0.441      34.9       -4.89 
      20 active1     1.75 subgroup1     -1.46      0.605      34.0       -2.69 
      21 active2     1.75 subgroup1     -2.39      0.477      35.1       -3.36 
      22 control     0.25 subgroup2     -1.59      0.273      38.0       -2.15 
      23 active1     0.25 subgroup2     -0.798     0.259      34.2       -1.32 
      24 active2     0.25 subgroup2     -0.806     0.253      35.5       -1.32 
      25 control     0.5  subgroup2     -2.77      0.445      39.7       -3.67 
      26 active1     0.5  subgroup2     -1.34      0.425      34.0       -2.21 
      27 active2     0.5  subgroup2     -1.42      0.415      36.8       -2.26 
      28 control     0.75 subgroup2     -3.12      0.461      41.1       -4.05 
      29 active1     0.75 subgroup2     -1.39      0.432      33.1       -2.27 
      30 active2     0.75 subgroup2     -1.67      0.436      38.3       -2.55 
      31 control     1    subgroup2     -2.88      0.463      35.8       -3.81 
      32 active1     1    subgroup2     -1.04      0.400      31.7       -1.86 
      33 active2     1    subgroup2     -1.61      0.455      35.5       -2.53 
      34 control     1.25 subgroup2     -2.92      0.481      30.8       -3.90 
      35 active1     1.25 subgroup2     -0.742     0.420      29.6       -1.60 
      36 active2     1.25 subgroup2     -1.58      0.487      31.6       -2.57 
      37 control     1.5  subgroup2     -3.93      0.390      36.5       -4.72 
      38 active1     1.5  subgroup2     -0.851     0.373      30.7       -1.61 
      39 active2     1.5  subgroup2     -1.84      0.397      35.7       -2.65 
      40 control     1.75 subgroup2     -5.63      0.599      35.0       -6.85 
      41 active1     1.75 subgroup2     -1.26      0.450      33.6       -2.18 
      42 active2     1.75 subgroup2     -2.33      0.531      35.0       -3.41 
      43 control     0.25 subgroup3     -0.743     0.277      35.4       -1.31 
      44 active1     0.25 subgroup3      0.251     0.259      34.6       -0.275
      45 active2     0.25 subgroup3     -0.949     0.257      40.7       -1.47 
      46 control     0.5  subgroup3     -1.41      0.450      36.4       -2.33 
      47 active1     0.5  subgroup3      0.267     0.422      35.5       -0.589
      48 active2     0.5  subgroup3     -1.72      0.421      41.4       -2.57 
      49 control     0.75 subgroup3     -1.95      0.453      37.7       -2.86 
      50 active1     0.75 subgroup3     -0.173     0.432      36.4       -1.05 
      51 active2     0.75 subgroup3     -2.13      0.427      41.2       -2.99 
      52 control     1    subgroup3     -2.37      0.436      35.5       -3.25 
      53 active1     1    subgroup3     -0.942     0.433      34.6       -1.82 
      54 active2     1    subgroup3     -2.23      0.395      35.7       -3.04 
      55 control     1.25 subgroup3     -2.82      0.463      31.0       -3.76 
      56 active1     1.25 subgroup3     -1.54      0.477      30.8       -2.51 
      57 active2     1.25 subgroup3     -2.32      0.411      29.9       -3.16 
      58 control     1.5  subgroup3     -3.41      0.392      34.9       -4.20 
      59 active1     1.5  subgroup3     -1.57      0.406      33.3       -2.40 
      60 active2     1.5  subgroup3     -2.61      0.358      32.6       -3.33 
      61 control     1.75 subgroup3     -4.10      0.560      35.5       -5.24 
      62 active1     1.75 subgroup3     -1.20      0.479      35.8       -2.18 
      63 active2     1.75 subgroup3     -3.05      0.458      36.3       -3.98 
         change_upper change_test_statistic change_p_value
                <dbl>                 <dbl>          <dbl>
       1      -0.772                 -5.12        1.03e- 5
       2      -0.241                 -2.97        5.33e- 3
       3      -0.949                 -5.43        4.13e- 6
       4      -1.54                  -5.75        1.34e- 6
       5      -0.531                 -3.30        2.16e- 3
       6      -1.76                  -5.88        9.88e- 7
       7      -2.23                  -7.22        1.41e- 8
       8      -0.826                 -3.93        3.51e- 4
       9      -2.21                  -6.79        5.86e- 8
      10      -2.62                  -8.39        8.37e-10
      11      -0.811                 -3.80        5.73e- 4
      12      -2.08                  -6.72        1.08e- 7
      13      -2.76                  -8.47        1.92e- 9
      14      -0.646                 -3.36        2.13e- 3
      15      -1.65                  -5.54        5.16e- 6
      16      -3.05                 -10.3         1.09e-11
      17      -0.751                 -3.94        3.62e- 4
      18      -1.61                  -6.09        7.53e- 7
      19      -3.10                  -9.05        1.13e-10
      20      -0.231                 -2.41        2.13e- 2
      21      -1.43                  -5.02        1.50e- 5
      22      -1.04                  -5.85        9.13e- 7
      23      -0.271                 -3.08        4.10e- 3
      24      -0.293                 -3.18        3.02e- 3
      25      -1.87                  -6.22        2.43e- 7
      26      -0.480                 -3.16        3.29e- 3
      27      -0.582                 -3.43        1.50e- 3
      28      -2.19                  -6.78        3.38e- 8
      29      -0.514                 -3.23        2.83e- 3
      30      -0.786                 -3.83        4.65e- 4
      31      -1.94                  -6.22        3.65e- 7
      32      -0.225                 -2.60        1.40e- 2
      33      -0.686                 -3.54        1.15e- 3
      34      -1.94                  -6.07        1.04e- 6
      35       0.117                 -1.76        8.81e- 2
      36      -0.587                 -3.24        2.79e- 3
      37      -3.14                 -10.1         4.38e-12
      38      -0.0899                -2.28        2.96e- 2
      39      -1.04                  -4.64        4.53e- 5
      40      -4.42                  -9.41        4.04e-11
      41      -0.348                 -2.81        8.27e- 3
      42      -1.25                  -4.38        1.03e- 4
      43      -0.181                 -2.68        1.11e- 2
      44       0.777                  0.968       3.40e- 1
      45      -0.430                 -3.69        6.52e- 4
      46      -0.503                 -3.14        3.31e- 3
      47       1.12                   0.633       5.31e- 1
      48      -0.868                 -4.08        1.99e- 4
      49      -1.03                  -4.30        1.17e- 4
      50       0.703                 -0.400       6.92e- 1
      51      -1.27                  -4.98        1.17e- 5
      52      -1.48                  -5.43        4.14e- 6
      53      -0.0622                -2.17        3.66e- 2
      54      -1.43                  -5.65        2.08e- 6
      55      -1.87                  -6.09        9.63e- 7
      56      -0.564                 -3.22        3.00e- 3
      57      -1.48                  -5.65        3.80e- 6
      58      -2.61                  -8.70        2.88e-10
      59      -0.746                 -3.87        4.80e- 4
      60      -1.88                  -7.28        2.52e- 8
      61      -2.96                  -7.33        1.34e- 8
      62      -0.232                 -2.51        1.66e- 2
      63      -2.12                  -6.67        8.60e- 8

---

    Code
      print(test_splinetrials_analysis_base_actual$between_te_tbl, width = Inf, n = Inf)
    Output
      # A tibble: 42 x 10
         arm     time_num subgroup  diff_subgroup_est diff_subgroup_se
         <fct>      <dbl> <fct>                 <dbl>            <dbl>
       1 control     0.25 subgroup2           -0.315             0.368
       2 active1     0.25 subgroup2           -0.0366            0.365
       3 active2     0.25 subgroup2            0.710             0.378
       4 control     0.5  subgroup2           -0.396             0.603
       5 active1     0.5  subgroup2            0.0340            0.596
       6 active2     0.5  subgroup2            1.26              0.618
       7 control     0.75 subgroup2           -0.0243            0.625
       8 active1     0.75 subgroup2            0.312             0.613
       9 active2     0.75 subgroup2            1.48              0.638
      10 control     1    subgroup2            0.580             0.616
      11 active1     1    subgroup2            0.704             0.610
      12 active2     1    subgroup2            1.37              0.636
      13 control     1.25 subgroup2            0.719             0.642
      14 active1     1.25 subgroup2            0.907             0.647
      15 active2     1.25 subgroup2            1.03              0.678
      16 control     1.5  subgroup2           -0.120             0.535
      17 active1     1.5  subgroup2            0.697             0.543
      18 active2     1.5  subgroup2            0.576             0.563
      19 control     1.75 subgroup2           -1.64              0.741
      20 active1     1.75 subgroup2            0.199             0.755
      21 active2     1.75 subgroup2            0.0664            0.715
      22 control     0.25 subgroup3            0.536             0.374
      23 active1     0.25 subgroup3            1.01              0.364
      24 active2     0.25 subgroup3            0.567             0.380
      25 control     0.5  subgroup3            0.957             0.612
      26 active1     0.5  subgroup3            1.64              0.593
      27 active2     0.5  subgroup3            0.962             0.621
      28 control     0.75 subgroup3            1.15              0.626
      29 active1     0.75 subgroup3            1.53              0.612
      30 active2     0.75 subgroup3            1.02              0.631
      31 control     1    subgroup3            1.09              0.602
      32 active1     1    subgroup3            0.802             0.631
      33 active2     1    subgroup3            0.742             0.593
      34 control     1.25 subgroup3            0.818             0.633
      35 active1     1.25 subgroup3            0.112             0.685
      36 active2     1.25 subgroup3            0.291             0.624
      37 control     1.5  subgroup3            0.399             0.541
      38 active1     1.5  subgroup3           -0.0230            0.565
      39 active2     1.5  subgroup3           -0.186             0.534
      40 control     1.75 subgroup3           -0.106             0.714
      41 active1     1.75 subgroup3            0.257             0.772
      42 active2     1.75 subgroup3           -0.660             0.662
         diff_subgroup_df diff_subgroup_lower diff_subgroup_upper
                    <dbl>               <dbl>               <dbl>
       1             37.8            -1.06                  0.430
       2             35.8            -0.777                 0.704
       3             35.7            -0.0566                1.48 
       4             38.9            -1.62                  0.825
       5             36.0            -1.17                  1.24 
       6             36.5             0.00491               2.51 
       7             39.8            -1.29                  1.24 
       8             35.8            -0.931                 1.55 
       9             37.4             0.192                 2.78 
      10             35.7            -0.669                 1.83 
      11             34.1            -0.535                 1.94 
      12             35.0             0.0768                2.66 
      13             30.7            -0.591                 2.03 
      14             31.1            -0.412                 2.23 
      15             31.1            -0.355                 2.41 
      16             34.9            -1.21                  0.966
      17             33.7            -0.405                 1.80 
      18             34.6            -0.567                 1.72 
      19             36.6            -3.14                 -0.139
      20             35.9            -1.33                  1.73 
      21             35.4            -1.38                  1.52 
      22             36.0            -0.223                 1.29 
      23             35.5             0.273                 1.75 
      24             38.2            -0.202                 1.34 
      25             36.9            -0.283                 2.20 
      26             36.4             0.442                 2.85 
      27             38.9            -0.293                 2.22 
      28             37.5            -0.116                 2.42 
      29             37.3             0.293                 2.77 
      30             38.9            -0.254                 2.30 
      31             34.9            -0.133                 2.31 
      32             34.8            -0.480                 2.08 
      33             34.8            -0.462                 1.95 
      34             30.6            -0.473                 2.11 
      35             31.2            -1.28                  1.51 
      36             30.1            -0.983                 1.56 
      37             34.1            -0.700                 1.50 
      38             35.0            -1.17                  1.12 
      39             33.0            -1.27                  0.901
      40             36.3            -1.55                  1.34 
      41             36.0            -1.31                  1.82 
      42             35.8            -2.00                  0.682
         diff_subgroup_test_statistic diff_subgroup_p_value
                                <dbl>                 <dbl>
       1                      -0.856                0.397  
       2                      -0.100                0.921  
       3                       1.88                 0.0684 
       4                      -0.656                0.516  
       5                       0.0571               0.955  
       6                       2.03                 0.0492 
       7                      -0.0389               0.969  
       8                       0.509                0.614  
       9                       2.33                 0.0255 
      10                       0.942                0.353  
      11                       1.15                 0.256  
      12                       2.15                 0.0385 
      13                       1.12                 0.271  
      14                       1.40                 0.171  
      15                       1.52                 0.140  
      16                      -0.224                0.824  
      17                       1.29                 0.207  
      18                       1.02                 0.313  
      19                      -2.21                 0.0331 
      20                       0.263                0.794  
      21                       0.0929               0.927  
      22                       1.43                 0.161  
      23                       2.78                 0.00867
      24                       1.49                 0.144  
      25                       1.56                 0.126  
      26                       2.77                 0.00872
      27                       1.55                 0.129  
      28                       1.84                 0.0736 
      29                       2.50                 0.0168 
      30                       1.62                 0.113  
      31                       1.81                 0.0790 
      32                       1.27                 0.212  
      33                       1.25                 0.219  
      34                       1.29                 0.206  
      35                       0.163                0.871  
      36                       0.466                0.645  
      37                       0.738                0.465  
      38                      -0.0406               0.968  
      39                      -0.348                0.730  
      40                      -0.149                0.883  
      41                       0.333                0.741  
      42                      -0.997                0.325  

---

    Code
      print(test_splinetrials_analysis_base_actual$within_te_tbl, width = Inf, n = Inf)
    Output
      # A tibble: 42 x 10
         arm     time_num subgroup  diff_arm_est diff_arm_se diff_arm_df
         <fct>      <dbl> <fct>            <dbl>       <dbl>       <dbl>
       1 active1     0.25 subgroup1       0.518        0.279        22.4
       2 active2     0.25 subgroup1      -0.237        0.288        21.7
       3 active1     0.5  subgroup1       0.995        0.438        22.4
       4 active2     0.5  subgroup1      -0.308        0.453        21.5
       5 active1     0.75 subgroup1       1.39         0.420        21.9
       6 active2     0.75 subgroup1      -0.0550       0.428        21.0
       7 active1     1    subgroup1       1.71         0.472        21.0
       8 active2     1    subgroup1       0.479        0.447        20.2
       9 active1     1.25 subgroup1       1.99         0.547        21.4
      10 active2     1.25 subgroup1       1.03         0.531        21.2
      11 active1     1.5  subgroup1       2.26         0.374        20.3
      12 active2     1.5  subgroup1       1.39         0.389        19.4
      13 active1     1.75 subgroup1       2.53         0.571        22.1
      14 active2     1.75 subgroup1       1.60         0.444        19.8
      15 active1     0.25 subgroup2       0.796        0.291        23.0
      16 active2     0.25 subgroup2       0.788        0.293        21.9
      17 active1     0.5  subgroup2       1.43         0.457        22.8
      18 active2     0.5  subgroup2       1.35         0.460        21.8
      19 active1     0.75 subgroup2       1.73         0.433        22.1
      20 active2     0.75 subgroup2       1.45         0.446        21.4
      21 active1     1    subgroup2       1.84         0.461        21.6
      22 active2     1    subgroup2       1.27         0.507        20.9
      23 active1     1.25 subgroup2       2.18         0.535        22.5
      24 active2     1.25 subgroup2       1.34         0.582        21.4
      25 active1     1.5  subgroup2       3.08         0.378        20.9
      26 active2     1.5  subgroup2       2.08         0.389        20.1
      27 active1     1.75 subgroup2       4.37         0.567        22.0
      28 active2     1.75 subgroup2       3.31         0.627        21.2
      29 active1     0.25 subgroup3       0.994        0.308        22.8
      30 active2     0.25 subgroup3      -0.206        0.297        23.2
      31 active1     0.5  subgroup3       1.68         0.481        22.6
      32 active2     0.5  subgroup3      -0.302        0.465        23.2
      33 active1     0.75 subgroup3       1.77         0.450        22.1
      34 active2     0.75 subgroup3      -0.184        0.433        22.8
      35 active1     1    subgroup3       1.42         0.477        22.0
      36 active2     1    subgroup3       0.133        0.444        21.8
      37 active1     1.25 subgroup3       1.28         0.568        22.7
      38 active2     1.25 subgroup3       0.502        0.523        22.3
      39 active1     1.5  subgroup3       1.84         0.411        20.5
      40 active2     1.5  subgroup3       0.803        0.379        20.8
      41 active1     1.75 subgroup3       2.90         0.549        21.6
      42 active2     1.75 subgroup3       1.05         0.539        22.1
         diff_arm_lower diff_arm_upper diff_arm_test_statistic diff_arm_p_value
                  <dbl>          <dbl>                   <dbl>            <dbl>
       1        -0.0604          1.10                    1.86      0.0768      
       2        -0.834           0.361                  -0.823     0.420       
       3         0.0889          1.90                    2.28      0.0328      
       4        -1.25            0.633                  -0.680     0.504       
       5         0.522           2.27                    3.32      0.00315     
       6        -0.946           0.836                  -0.128     0.899       
       7         0.731           2.69                    3.63      0.00157     
       8        -0.454           1.41                    1.07      0.297       
       9         0.851           3.13                    3.63      0.00153     
      10        -0.0751          2.13                    1.94      0.0662      
      11         1.48            3.04                    6.04      0.00000618  
      12         0.576           2.20                    3.57      0.00198     
      13         1.35            3.72                    4.44      0.000205    
      14         0.673           2.53                    3.60      0.00180     
      15         0.194           1.40                    2.73      0.0118      
      16         0.180           1.40                    2.69      0.0135      
      17         0.479           2.37                    3.12      0.00486     
      18         0.391           2.30                    2.92      0.00791     
      19         0.833           2.63                    4.00      0.000604    
      20         0.527           2.38                    3.26      0.00370     
      21         0.879           2.79                    3.98      0.000647    
      22         0.212           2.32                    2.50      0.0209      
      23         1.07            3.29                    4.07      0.000492    
      24         0.129           2.55                    2.30      0.0317      
      25         2.29            3.86                    8.15      0.0000000628
      26         1.27            2.90                    5.36      0.0000302   
      27         3.20            5.55                    7.72      0.000000106 
      28         2.00            4.61                    5.28      0.0000304   
      29         0.358           1.63                    3.23      0.00371     
      30        -0.819           0.407                  -0.694     0.494       
      31         0.685           2.68                    3.49      0.00199     
      32        -1.26            0.659                  -0.650     0.522       
      33         0.840           2.71                    3.94      0.000693    
      34        -1.08            0.711                  -0.426     0.674       
      35         0.435           2.41                    2.99      0.00680     
      36        -0.788           1.05                    0.299     0.768       
      37         0.106           2.46                    2.26      0.0340      
      38        -0.582           1.59                    0.960     0.347       
      39         0.983           2.69                    4.48      0.000219    
      40         0.0143          1.59                    2.12      0.0463      
      41         1.76            4.04                    5.27      0.0000290   
      42        -0.0714          2.17                    1.94      0.0651      

---

    Code
      print(test_splinetrials_analysis_base_actual$percent_slowing_tbl, width = Inf,
      n = Inf)
    Output
      # A tibble: 42 x 6
         arm     time_num subgroup  percent_slowing_est percent_slowing_lower
         <fct>      <dbl> <fct>                   <dbl>                 <dbl>
       1 active1     0.25 subgroup1               40.5                  -4.93
       2 active2     0.25 subgroup1              -18.5                 -80.9 
       3 active1     0.5  subgroup1               42.0                   2.24
       4 active2     0.5  subgroup1              -13.0                 -66.8 
       5 active1     0.75 subgroup1               45.0                  13.7 
       6 active2     0.75 subgroup1               -1.77                -42.1 
       7 active1     1    subgroup1               49.5                  20.9 
       8 active2     1    subgroup1               13.8                 -18.4 
       9 active1     1.25 subgroup1               54.7                  26.2 
      10 active2     1.25 subgroup1               28.3                  -2.00
      11 active1     1.5  subgroup1               59.3                  37.7 
      12 active2     1.5  subgroup1               36.5                  12.7 
      13 active1     1.75 subgroup1               63.4                  32.7 
      14 active2     1.75 subgroup1               40.1                  13.3 
      15 active1     0.25 subgroup2               50.0                  13.9 
      16 active2     0.25 subgroup2               49.4                  14.0 
      17 active1     0.5  subgroup2               51.5                  17.8 
      18 active2     0.5  subgroup2               48.6                  15.1 
      19 active1     0.75 subgroup2               55.4                  25.4 
      20 active2     0.75 subgroup2               46.6                  15.2 
      21 active1     1    subgroup2               63.8                  34.3 
      22 active2     1    subgroup2               44.1                   8.42
      23 active1     1.25 subgroup2               74.6                  45.2 
      24 active2     1.25 subgroup2               45.9                   8.77
      25 active1     1.5  subgroup2               78.3                  59.3 
      26 active2     1.5  subgroup2               53.1                  31.2 
      27 active1     1.75 subgroup2               77.6                  61.3 
      28 active2     1.75 subgroup2               58.7                  38.3 
      29 active1     0.25 subgroup3              134.                   61.1 
      30 active2     0.25 subgroup3              -27.7                -143.  
      31 active1     0.5  subgroup3              119.                   59.3 
      32 active2     0.5  subgroup3              -21.4                -117.  
      33 active1     0.75 subgroup3               91.1                  47.5 
      34 active2     0.75 subgroup3               -9.48                -75.4 
      35 active1     1    subgroup3               60.2                  21.5 
      36 active2     1    subgroup3                5.60                -41.6 
      37 active1     1.25 subgroup3               45.5                   7.97
      38 active2     1.25 subgroup3               17.8                 -21.1 
      39 active1     1.5  subgroup3               53.9                  28.4 
      40 active2     1.5  subgroup3               23.6                  -3.26
      41 active1     1.75 subgroup3               70.6                  46.4 
      42 active2     1.75 subgroup3               25.5                  -4.05
         percent_slowing_upper
                         <dbl>
       1                  85.9
       2                  43.9
       3                  81.7
       4                  40.9
       5                  76.2
       6                  38.6
       7                  78.1
       8                  46.1
       9                  83.1
      10                  58.6
      11                  81.0
      12                  60.2
      13                  94.1
      14                  66.8
      15                  86.0
      16                  84.9
      17                  85.2
      18                  82.1
      19                  85.4
      20                  78.0
      21                  93.4
      22                  79.7
      23                 104. 
      24                  83.0
      25                  97.4
      26                  74.9
      27                  93.9
      28                  79.1
      29                 206. 
      30                  87.6
      31                 178. 
      32                  74.1
      33                 135. 
      34                  56.5
      35                  98.8
      36                  52.8
      37                  83.0
      38                  56.7
      39                  79.4
      40                  50.4
      41                  94.8
      42                  55.1

---

    Code
      print(test_splinetrials_analysis_base_no_subgroup_actual$response_stats_tbl,
      width = Inf, n = Inf)
    Output
      # A tibble: 24 x 9
         arm     time     time_num     n   est    sd    se lower upper
         <fct>   <chr>       <dbl> <int> <dbl> <dbl> <dbl> <dbl> <dbl>
       1 active1 Baseline     0       19 10.0  1.04  0.240  9.57 10.5 
       2 active1 visit 3      0.25    19  9.13 0.909 0.208  8.72  9.54
       3 active1 visit 4      0.5     19  9.02 1.10  0.253  8.53  9.52
       4 active1 visit 5      0.75    19  9.08 0.969 0.222  8.65  9.52
       5 active1 visit 7      1       19  8.57 1.17  0.268  8.05  9.10
       6 active1 visit 8      1.25    19  8.72 0.861 0.198  8.34  9.11
       7 active1 visit 9      1.5     19  9.16 1.21  0.278  8.61  9.70
       8 active1 visit 12     1.75    19  8.83 0.851 0.195  8.45  9.21
       9 active2 Baseline     0       13 10.3  0.883 0.245  9.82 10.8 
      10 active2 visit 3      0.25    13  8.49 1.10  0.304  7.90  9.09
      11 active2 visit 4      0.5     13  8.85 0.657 0.182  8.50  9.21
      12 active2 visit 5      0.75    13  7.65 1.34  0.372  6.92  8.38
      13 active2 visit 7      1       13  7.84 1.05  0.291  7.27  8.41
      14 active2 visit 8      1.25    13  8.22 0.997 0.277  7.68  8.76
      15 active2 visit 9      1.5     13  7.46 0.938 0.260  6.95  7.97
      16 active2 visit 12     1.75    13  8.05 0.989 0.274  7.51  8.59
      17 control Baseline     0       18 10.0  0.921 0.217  9.60 10.4 
      18 control visit 3      0.25    18  8.52 1.09  0.258  8.01  9.02
      19 control visit 4      0.5     18  8.22 0.889 0.210  7.81  8.63
      20 control visit 5      0.75    18  7.08 1.07  0.253  6.59  7.58
      21 control visit 7      1       18  7.04 0.849 0.200  6.64  7.43
      22 control visit 8      1.25    18  6.87 0.769 0.181  6.51  7.22
      23 control visit 9      1.5     18  6.08 0.953 0.225  5.64  6.52
      24 control visit 12     1.75    18  5.95 0.936 0.221  5.51  6.38

---

    Code
      print(test_splinetrials_analysis_base_no_subgroup_actual$emmeans_tbl, width = Inf,
      n = Inf)
    Output
       arm     time_num response_est response_se response_df response_lower
       control     0.00     9.947569   0.1265691    50.36837       9.693394
       active1     0.00     9.947569   0.1265691    50.36837       9.693394
       active2     0.00     9.947569   0.1265691    50.36837       9.693394
       control     0.25     8.901634   0.1063729    60.86476       8.688919
       active1     0.25     9.395703   0.1047692    61.46791       9.186236
       active2     0.25     9.188051   0.1201769    62.40855       8.947852
       control     0.50     7.995316   0.1490526    52.11956       7.696237
       active1     0.50     8.944886   0.1439607    50.70601       8.655832
       active2     0.50     8.539914   0.1738315    52.42097       8.191162
       control     0.75     7.355411   0.1430764    54.40822       7.068610
       active1     0.75     8.688724   0.1377057    52.59508       8.412471
       active2     0.75     8.106874   0.1679385    53.79927       7.770148
       control     1.00     6.948276   0.1381614    49.39740       6.670687
       active1     1.00     8.627702   0.1343995    49.59936       8.357698
       active2     1.00     7.896754   0.1647832    51.01140       7.565939
       control     1.25     6.631088   0.1533707    48.18345       6.322746
       active1     1.25     8.698934   0.1499023    48.97128       8.397689
       active2     1.25     7.852120   0.1821107    50.26164       7.486387
       control     1.50     6.285500   0.1293969    46.74098       6.025149
       active1     1.50     8.843896   0.1260331    47.12153       8.590367
       active2     1.50     7.916427   0.1538210    48.09176       7.607164
       control     1.75     5.906174   0.1859376    48.77209       5.532475
       active1     1.75     9.027783   0.1831542    48.76846       8.659676
       active2     1.75     8.042229   0.2227850    49.42230       7.594623
       response_upper
            10.201745
            10.201745
            10.201745
             9.114349
             9.605170
             9.428250
             8.294396
             9.233940
             8.888665
             7.642213
             8.964976
             8.443599
             7.225865
             8.897705
             8.227568
             6.939430
             9.000178
             8.217853
             6.545851
             9.097424
             8.225689
             6.279874
             9.395889
             8.489836
      
      Results are averaged over the levels of: 2 nuisance factors, time_observed_index 
      Confidence level used: 0.95 

---

    Code
      print(test_splinetrials_analysis_base_no_subgroup_actual$treatment_effect_tbl,
      width = Inf, n = Inf)
    Output
      # A tibble: 14 x 9
         arm     time_num diff_est diff_se diff_df diff_lower diff_upper
         <fct>      <dbl>    <dbl>   <dbl>   <dbl>      <dbl>      <dbl>
       1 active1     0.25    0.494   0.132    50.8    0.229        0.759
       2 active2     0.25    0.286   0.147    53.1   -0.00755      0.580
       3 active1     0.5     0.950   0.206    50.3    0.536        1.36 
       4 active2     0.5     0.545   0.230    52.7    0.0835       1.01 
       5 active1     0.75    1.33    0.191    48.1    0.948        1.72 
       6 active2     0.75    0.751   0.216    50.4    0.317        1.19 
       7 active1     1       1.68    0.187    45.7    1.30         2.06 
       8 active2     1       0.948   0.212    48.3    0.522        1.37 
       9 active1     1.25    2.07    0.212    47.5    1.64         2.49 
      10 active2     1.25    1.22    0.238    49.8    0.743        1.70 
      11 active1     1.5     2.56    0.179    46.1    2.20         2.92 
      12 active2     1.5     1.63    0.202    48.1    1.22         2.04 
      13 active1     1.75    3.12    0.259    47.8    2.60         3.64 
      14 active2     1.75    2.14    0.291    49.5    1.55         2.72 
         diff_test_statistic diff_p_value
                       <dbl>        <dbl>
       1                3.74     4.67e- 4
       2                1.95     5.60e- 2
       3                4.61     2.83e- 5
       4                2.37     2.15e- 2
       5                6.97     8.22e- 9
       6                3.47     1.07e- 3
       7                8.99     1.14e-11
       8                4.47     4.71e- 5
       9                9.74     6.64e-13
      10                5.13     4.82e- 6
      11               14.3      1.45e-18
      12                8.08     1.66e-10
      13               12.0      4.44e-16
      14                7.34     1.84e- 9

---

    Code
      print(test_splinetrials_analysis_base_no_subgroup_actual$treatment_effect_tbl,
      width = Inf, n = Inf)
    Output
      # A tibble: 14 x 9
         arm     time_num diff_est diff_se diff_df diff_lower diff_upper
         <fct>      <dbl>    <dbl>   <dbl>   <dbl>      <dbl>      <dbl>
       1 active1     0.25    0.494   0.132    50.8    0.229        0.759
       2 active2     0.25    0.286   0.147    53.1   -0.00755      0.580
       3 active1     0.5     0.950   0.206    50.3    0.536        1.36 
       4 active2     0.5     0.545   0.230    52.7    0.0835       1.01 
       5 active1     0.75    1.33    0.191    48.1    0.948        1.72 
       6 active2     0.75    0.751   0.216    50.4    0.317        1.19 
       7 active1     1       1.68    0.187    45.7    1.30         2.06 
       8 active2     1       0.948   0.212    48.3    0.522        1.37 
       9 active1     1.25    2.07    0.212    47.5    1.64         2.49 
      10 active2     1.25    1.22    0.238    49.8    0.743        1.70 
      11 active1     1.5     2.56    0.179    46.1    2.20         2.92 
      12 active2     1.5     1.63    0.202    48.1    1.22         2.04 
      13 active1     1.75    3.12    0.259    47.8    2.60         3.64 
      14 active2     1.75    2.14    0.291    49.5    1.55         2.72 
         diff_test_statistic diff_p_value
                       <dbl>        <dbl>
       1                3.74     4.67e- 4
       2                1.95     5.60e- 2
       3                4.61     2.83e- 5
       4                2.37     2.15e- 2
       5                6.97     8.22e- 9
       6                3.47     1.07e- 3
       7                8.99     1.14e-11
       8                4.47     4.71e- 5
       9                9.74     6.64e-13
      10                5.13     4.82e- 6
      11               14.3      1.45e-18
      12                8.08     1.66e-10
      13               12.0      4.44e-16
      14                7.34     1.84e- 9

---

    Code
      print(test_splinetrials_analysis_base_no_subgroup_actual$percent_slowing_tbl,
      width = Inf, n = Inf)
    Output
      # A tibble: 14 x 5
         arm     time_num percent_slowing_est percent_slowing_lower
         <fct>      <dbl>               <dbl>                 <dbl>
       1 active1     0.25                47.2                 21.7 
       2 active2     0.25                27.4                 -3.15
       3 active1     0.5                 48.6                 26.2 
       4 active2     0.5                 27.9                  1.12
       5 active1     0.75                51.4                 33.8 
       6 active2     0.75                29.0                  8.01
       7 active1     1                   56.0                 41.4 
       8 active2     1                   31.6                 14.1 
       9 active1     1.25                62.4                 49.2 
      10 active2     1.25                36.8                 21.0 
      11 active1     1.5                 69.9                 59.3 
      12 active2     1.5                 44.5                 32.1 
      13 active1     1.75                77.2                 65.7 
      14 active2     1.75                52.9                 39.0 
         percent_slowing_upper
                         <dbl>
       1                  72.8
       2                  57.9
       3                  71.1
       4                  54.7
       5                  69.1
       6                  50.0
       7                  70.6
       8                  49.1
       9                  75.5
      10                  52.6
      11                  80.4
      12                  57.0
      13                  88.8
      14                  66.7

