% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prcomp.R
\name{prcomp}
\alias{prcomp}
\alias{prcomp.stars_proxy}
\alias{prcomp.stars}
\title{Principle components of stars object}
\usage{
\method{prcomp}{stars_proxy}(x, ..., downsample = 0)

\method{prcomp}{stars}(x, ..., quiet = FALSE)
}
\arguments{
\item{x}{object of class `stars` or `stars_proxy`}

\item{...}{see \link[stats]{prcomp}}

\item{downsample}{see \link{st_as_stars}}

\item{quiet}{logical; if `TRUE`, suppress message that PCs will be computed on last dimension; see details}
}
\value{
object of class `prcomp`, see \link[stats]{prcomp}
}
\description{
Compute principle components of stars object
}
\details{
if `x` has only one attribute, principle components will be computed in the space of the last dimension of `x`
to predict PC scores into a `stars` object, use \link{predict.stars}; see example below
}
\examples{
l7 = split(st_as_stars(L7_ETMs), 3) # use bands as features
plot(prcomp(l7))
plot(merge(predict(l7, model = prcomp(l7))))
}
