% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.R
\name{st_rotate}
\alias{st_rotate}
\alias{st_rotate.stars}
\alias{st_rotate.sfc}
\alias{st_rotate.sf}
\title{Transform rotated pole long/lat regular grid to unrotated curvilinear grid}
\usage{
\method{st_rotate}{stars}(.x, lon0, lat0, north = TRUE, ...)

\method{st_rotate}{sfc}(.x, lon0, lat0, north = TRUE, ...)

\method{st_rotate}{sf}(.x, lon0, lat0, north = TRUE, ...)
}
\arguments{
\item{.x}{object of class \code{stars}}

\item{lon0}{longitude of the rotated pole in degrees}

\item{lat0}{latitude of the rotated pole in degrees}

\item{north}{logical; if \code{TRUE} the pole refers to the North pole, otherwise the South pole}

\item{...}{ignored}
}
\value{
curvilinear stars object with coordinates in regular long/lat (North pole at lat=90)
}
\description{
Transform rotated long/lat regular grid to unrotated curvilinear grid
}
\examples{
if (require("starsdata") && require("maps")) {
  # data downloaded from https://esgf-data.dkrz.de/search/cosmo-rea/
  nc = "netcdf/ts_EUR-6km_ECMWF-ERAINT_REA6_r1i1p1f1_COSMO_v1_mon_201801-201812.nc"
  f = system.file(nc, package = "starsdata")
  m = read_mdim(f, "ts")
  print(m)
  # NOTE this function is obsolete when reading m as
  # m = read_mdim(f, "ts", curvilinear = c("longitude", "latitude"))
  if (require(RNetCDF)) {
     x = open.nc(f)
     lon = att.get.nc(x, "rotated_latitude_longitude", "grid_north_pole_longitude")
     lat = att.get.nc(x, "rotated_latitude_longitude", "grid_north_pole_latitude")
     close.nc(x)
     print(c(lon = lon, lat = lat))
  } else {
     lon = -162
     lat = 39.25
  } 
  m1 = st_rotate(m, lon, lat)
  print(m1)
  h = function() maps::map(add = TRUE)
  plot(m1, downsample = c(10, 10, 5), axes = TRUE, hook = h, mfrow = c(1, 2)) 
    # curvilinear grid: downsample for plotting speed
  m2 = st_warp(m1, crs = st_crs("OGC:CRS84"), threshold = .1)
  plot(m2, hook = h, mfrow = c(3, 4)) # regular grid: plots fast
}
}
