% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.prop}
\alias{ci.prop}
\title{Confidence intervals for a proportion}
\usage{
ci.prop(alpha, f, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{number of participants who have the attribute}

\item{n}{sample size}
}
\value{
Returns a 2-row matrix. The columns of row 1 are:
\itemize{
\item Estimate - adjusted estimate of proportion
\item SE - standard error of adjusted estimate
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}

The columns of row 2 are:
\itemize{
\item Estimate - ML estimate of proportion
\item SE - standard error of ML estimate
\item LL - lower limit of the Wilson confidence interval
\item UL - upper limit of the Wilson confidence interval
}

The columns of row 3 are:
\itemize{
\item Estimate - ML estimate of proportion
\item SE - standard error of ML estimate
\item LL - lower limit of the exact confidence interval
\item UL - upper limit of the exact confidence interval
}
}
\description{
Computes adjusted Wald (Agresi-Coull), Wilson, and exact confidence intervals
for a population proportion. The Wilson confidence interval uses a
continuity correction.

For more details, see Section 1.5 of Bonett (2021, Volume 3)
}
\examples{
ci.prop(.05, 120, 300)

# Should return:
#                 Estimate         SE        LL        UL
# Adjusted Wald  0.4013158 0.02811287 0.3462156 0.4564160
# Wilson with cc 0.4000000 0.02828427 0.3445577 0.4580464
# Exact          0.4000000 0.02828427 0.3441290 0.4578664


}
\references{
\insertRef{Bonett2021}{statpsych}

\insertRef{Agresti1998}{statpsych}
}
