% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sunburstShinyWidget.R
\name{sunburstShinyWidget-shiny}
\alias{sunburstShinyWidget-shiny}
\alias{sunburstShinyWidgetOutput}
\alias{renderSunburstShinyWidget}
\title{Shiny bindings for sunburstShinyWidget}
\usage{
sunburstShinyWidgetOutput(outputId, width = "100\%", height = "400px")

renderSunburstShinyWidget(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a sunburstShinyWidget}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
\code{sunburstShinyWidgetOutput} returns a \code{shiny.tag.list} object
containing the HTML output container for the sunburst widget.

\code{renderSunburstShinyWidget} returns a \code{shiny.render.function} that
evaluates the given expression to produce a sunburst widget for the
corresponding output element.
}
\description{
Output and render functions for using sunburstShinyWidget within Shiny
applications and interactive Rmd documents.
}
