% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback_early_stopping}
\alias{callback_early_stopping}
\title{Early stopping callback for survdnn}
\usage{
callback_early_stopping(
  patience = 10L,
  min_delta = 0,
  mode = c("min", "max"),
  verbose = FALSE
)
}
\arguments{
\item{patience}{Integer. Number of epochs with no improvement before stopping.}

\item{min_delta}{Minimum change to qualify as an improvement (default: 0).}

\item{mode}{Character. "min" (for losses) or "max" (for metrics to maximize).}

\item{verbose}{Logical. Whether to print a message when early stopping is triggered.}
}
\value{
A function of the form `function(epoch, current)` that returns TRUE
  if training should stop, FALSE otherwise.
}
\description{
Simple early stopping on a monitored scalar, typically the training loss.
}
