% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poppk_mods.R
\name{pkmod_schnider}
\alias{pkmod_schnider}
\title{Schnider population PK model for propofol}
\usage{
pkmod_schnider(AGE, HGT, LBM = NULL, TBW = NULL, MALE = NULL, ...)
}
\arguments{
\item{AGE}{Age (years)}

\item{HGT}{Height (cm)}

\item{LBM}{Lean body mass (kg). Can be provided instead of TBW, and MALE}

\item{TBW}{Weight (kg). Used to calculate LBM if LBM is not provided.}

\item{MALE}{Logical. Used to calculate LBM if LBM is not provided.}

\item{...}{Arguments passed to `pkmod`}
}
\value{
`pkmod` object with Schnider population PK parameters
}
\description{
Evaluate Schnider population PK model at patient covariate values.
Published in Schnider et al. (1998). "The influence of method of administration
and covariates on the pharmacokinetics of propofol in adult volunteers."
Anesthesiology 88 (5):1170-82.
}
\examples{
pkmod_schnider(AGE = 40,HGT=170,LBM = 43.9)
pkmod_schnider(AGE = 40,HGT=170,TBW=50,MALE=TRUE)
}
