% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editor_block.R
\name{ui_editor_block}
\alias{ui_editor_block}
\alias{srv_editor_block}
\title{UI and Server functions for editing report document blocks}
\usage{
ui_editor_block(id, value, ...)

srv_editor_block(id, value, ...)
}
\arguments{
\item{id}{(\code{character(1)}) A unique identifier for the module.}

\item{value}{The content of the block to be edited. It can be a character string or other types.}

\item{...}{Additional arguments passed to dispatch functions.}
}
\description{
These functions provide a user interface and server logic for editing and extending
the editor functionality to support new data types.
}
\details{
The methods for this S3 generic can be extended by the app developer to new classes
or even overwritten.
For this a function with the name \verb{srv_editor_block.<class>} and/or \verb{ui_editor_block.<class>}
should be defined in the Global Environment, where \verb{<class>} is the class of
the object to be used in the method.

For example, to override the default behavior for \code{character} class, you can use:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ui_editor_block.character <- function(id, value) \{
  # custom implementation
  shiny::tagList(
    shiny::tags$h6(shiny::icon("pencil", class = "text-muted"), "Editable CUSTOM markdown block"),
    shiny::textAreaInput(ns("content"), label = NULL, value = value, width = "100\%")
  )
\}
srv_editor_block.character <- function(id, value) \{
 # custom implementation
 # ...
\}
}\if{html}{\out{</div>}}

Alternatively, you can register the S3 method using
\code{registerS3method("ui_editor_block", "<class>", fun)} and
\code{registerS3method("srv_editor_block", "<class>", fun)}.
\subsection{Optional arguments of \code{ui_editor_block}}{
\itemize{
\item \code{cached_html}: (\code{shiny.tag} or \code{shiny.tag.list}) Cached HTML content to display in the UI that is
rendered at the time the card is being added. Default is \code{NULL}.

\code{teal} will call on \code{ui_editor_block} with the contents of each element
of the card (\code{value} argument) and an optional parameter \code{cached_html}.
This parameter is not part of the S3 generic as it is optional when overriding the method.

The usage of this argument improve the UI performance by avoiding re-rendering on the fly.
When overriding this method, the usage of this argument is optional, hence it is not part of the S3 generic.
}
}
}
