% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{rose_stats}
\alias{rose_stats}
\title{Show Average Direction and Spread in Rose Diagram}
\usage{
rose_stats(
  x,
  weights = NULL,
  axial = TRUE,
  avg = c("mean", "median", "sample_median"),
  spread = c("CI", "fisher", "sd", "IQR", "mdev"),
  avg.col = "#B63679FF",
  avg.lty = 2,
  avg.lwd = 1.5,
  spread.col = ggplot2::alpha("#B63679FF", 0.2),
  spread.border = FALSE,
  spread.lty = NULL,
  spread.lwd = NULL,
  add = TRUE,
  ...
)
}
\arguments{
\item{x}{Data to be plotted. A numeric vector containing angles (in degrees).}

\item{weights}{Optional vector of numeric weights associated with x.}

\item{axial}{Logical. Whether data are uniaxial (\code{axial=FALSE})
or biaxial (\code{TRUE}, the default).}

\item{avg}{character. The average estimate for x. Either the circular mean
(\code{"mean"}, the default), the circular Quasi Median (\code{"median"}), or the
sample median (\code{"sample_median"}).}

\item{spread}{character. The measure of spread to be plotted as a fan.
Either Batchelet's 95\% confidence interval by (\code{"CI"}, the default),
Fisher's 95\% confidence interval (\code{"fisher"}), the circular
standard deviation (\code{"sd"}), the Quasi interquartile range on the circle
(\code{"IQR"}), or the sample median deviation (\code{"mdev"}). \code{NULL} if no fan should be drawn.}

\item{avg.col}{color for the average line}

\item{avg.lty}{line type of the average line}

\item{avg.lwd}{line width of the average line}

\item{spread.col}{color of the spread fan}

\item{spread.border}{logical. Whether to draw a border of the fan or not.}

\item{spread.lty}{line type of the spread fan's border}

\item{spread.lwd}{line width of the spread fan's border}

\item{add}{logical.}

\item{...}{optional arguments to \code{circular_plot()} if add is \code{FALSE}.}
}
\value{
plot or a two-element vector containing the calculated average and
spread when assigned.
}
\description{
Adds the average direction (and its spread) to an existing rose diagram.
}
\examples{
data("san_andreas")
rose(san_andreas$azi, weights = 1 / san_andreas$unc, muci = FALSE)
rose_stats(san_andreas$azi, weights = 1 / san_andreas$unc, avg = "sample_median", spread = "mdev")
}
\seealso{
\code{\link[=circular_mean]{circular_mean()}}, \code{\link[=circular_median]{circular_median()}}, \code{\link[=circular_sample_median]{circular_sample_median()}},
\code{\link[=confidence_interval]{confidence_interval()}}, \code{\link[=confidence_interval_fisher]{confidence_interval_fisher()}},
\code{\link[=circular_sd]{circular_sd()}}, \code{\link[=circular_IQR]{circular_IQR()}}, \code{\link[=circular_sample_median_deviation]{circular_sample_median_deviation()}}
for statistical parameters.

Other rose-plot: 
\code{\link{plot_density}()},
\code{\link{plot_points}()},
\code{\link{rose}()},
\code{\link{rose_geom}}
}
\concept{rose-plot}
