% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testit.R
\name{test_pkg}
\alias{test_pkg}
\title{Run the tests of a package in its namespace}
\usage{
test_pkg(package = pkg_name(), dir = c("testit", "tests/testit"), update = NA)
}
\arguments{
\item{package}{The package name. By default, it is detected from the
\file{DESCRIPTION} file if exists.}

\item{dir}{The directory of the test files; by default, it is the directory
\file{testit/} or \file{tests/testit/} under the current working directory,
whichever exists. You can also specify a custom directory.}

\item{update}{If \code{TRUE}, update snapshot files with actual output
instead of comparing. If \code{NA} (the default), update snapshot files
only if they are tracked by GIT (so you can view the diffs in GIT and
decide whether to accept or discard the changes). If \code{FALSE}, never
update snapshot files and always compare. For \code{NA} and \code{FALSE},
if the snapshot test fails, it will throw an error with a message showing
the location of the failed test. For \code{TRUE}, it will update the
snapshot file and never throw an error.}
}
\value{
\code{NULL}. All test files are executed, unless an error occurs.
}
\description{
The tests are executed in a clean environment with the namespace of the
package to be tested as the parent environment, which means you can use
non-exported objects in the package without having to resort to the triple
colon \code{\link{:::}} trick.
}
\details{
The tests are assumed to be under the \file{testit/} or \file{tests/testit/}
directory by default (depending on your working directory is the package root
directory or the \file{tests/} directory). The test scripts must be named of
the form \samp{test-*.R} (or \samp{test-*.md} for snapshot tests); other
files will not be treated as test files (but may also be useful, e.g. you can
\code{\link{source}()} other scripts in tests).

When a test is executed, the working directory is the same as the directory
containing this test, and all existing objects in the test environment will
be removed before the code is executed.

See \url{https://pkg.yihui.org/testit/#snapshot-testing} for more details
about snapshot testing.
}
\note{
All test scripts must be encoded in UTF-8 if they contain any multibyte
  characters.
}
\examples{
\dontrun{
test_pkg("testit")
}
}
