% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/python.R
\name{get_embeddings}
\alias{get_embeddings}
\title{Get Vector Embeddings (uses Python)}
\usage{
get_embeddings(x, model_path = NULL)
}
\arguments{
\item{x}{Character vector of text to be embedded.}

\item{model_path}{Atomic character vector referring to a folder with a
pretrained model. Default: NULL}
}
\value{
Matrix
}
\description{
This function wraps the 'transformers' library in 'Python',
to obtain vector embeddings (a numerical representation of meaning) for
a character vector based on a pretrained model.
}
\examples{
\dontrun{
if(requireNamespace("reticulate", quietly = TRUE)){
 tmp <- get_embeddings(c("cat", "my cat", "dog"),
 model_path = "scibert_scivocab_uncased")
 }
}
}
