% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc.R
\name{cohort}
\alias{cohort}
\title{Cohort Analysis}
\usage{
cohort(.data, .date, .value, time_unit = "month", period_label = FALSE)
}
\arguments{
\item{.data}{tibble or dbi object}

\item{.date}{date column}

\item{.value}{id column}

\item{time_unit}{do you want summarize the date column to 'day', 'week', 'month','quarter' or 'year'}

\item{period_label}{do you want period labels or the dates c(TRUE , FALSE)}
}
\value{
segment object
}
\description{
Database-friendly cohort analysis function.
A remake of \url{https://github.com/PeerChristensen/cohorts}, combining
\code{cohort_table_month}, \code{cohort_table_year}, and \code{cohort_table_day} into a single package.
Rewritten for database compatibility and tested with Snowflake and DuckDB.
}
\details{
\itemize{
\item Groups your \code{.value} column by shared time attributes from the \code{.date} column.
\item Assigns each member to a cohort based on their first entry in \code{.date}.
\item Aggregates the cohort by the \code{time_unit} argument (\code{day}, \code{week}, \code{month}, \code{quarter}, or \code{year}).
\item Computes the distinct count of each cohort member over time.
}
}
