% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-misc.R
\name{seq_date_sql}
\alias{seq_date_sql}
\title{Generate a Cross-Dialect SQL Date Series}
\usage{
seq_date_sql(
  .con,
  start_date,
  end_date,
  calendar_type = "standard",
  time_unit = "day",
  week_start = 7,
  fiscal_year_start = 1
)
}
\arguments{
\item{.con}{A valid DBI connection object (e.g., DuckDB, Postgres, Snowflake)
or a \code{dbplyr} simulated connection.}

\item{start_date}{A character string in 'YYYY-MM-DD' format or a Date object
representing the start of the series.}

\item{end_date}{A character string in 'YYYY-MM-DD' format or a Date object
representing the end of the series.}

\item{time_unit}{A character string specifying the interval. Must be one of:
\code{"day"}, \code{"week"}, \code{"month"}, \code{"quarter"}, or \code{"year"}.}

\item{week_start}{description}
}
\value{
A \code{tbl_lazy} (SQL) object with a single column \code{date}.
}
\description{
Creates a lazy \code{dbplyr} table containing a continuous sequence of dates.
The function automatically detects the SQL dialect of the connection and
dispatches the most efficient native series generator (e.g., \code{GENERATE_SERIES}
for DuckDB/Postgres or \code{GENERATOR} for Snowflake).
}
\details{
This function is designed to be "nestable," meaning the resulting SQL can be
used safely inside larger \code{dplyr} pipelines. It avoids \code{WITH} clauses in
dialects like DuckDB to prevent parser errors when \code{dbplyr} wraps the query
in a subquery (e.g., \verb{SELECT * FROM (...) AS q01}).

For unit testing, the function supports \code{dbplyr} simulation objects. If a
\code{TestConnection} is detected, it returns a \code{lazy_frame} to avoid metadata
field queries that would otherwise fail on a mock connection.
}
\keyword{internal}
