% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_generics.R, R/class-mod_cpt.R,
%   R/class-seg_basket.R, R/class-seg_cpt.R, R/class-tidycpt.R, R/pkg-GA.R,
%   R/pkg-changepoint.R, R/pkg-changepointGA.R, R/pkg-segmented.R,
%   R/pkg-strucchange.R, R/pkg-wbs.R
\name{changepoints}
\alias{changepoints}
\alias{changepoints.default}
\alias{changepoints.mod_cpt}
\alias{changepoints.seg_basket}
\alias{changepoints.seg_cpt}
\alias{changepoints.tidycpt}
\alias{changepoints.ga}
\alias{changepoints.cpt}
\alias{changepoints.cptga}
\alias{changepoints.segmented}
\alias{changepoints.breakpointsfull}
\alias{changepoints.wbs}
\title{Extract changepoints}
\usage{
changepoints(x, ...)

\method{changepoints}{default}(x, ...)

\method{changepoints}{mod_cpt}(x, ...)

\method{changepoints}{seg_basket}(x, ...)

\method{changepoints}{seg_cpt}(x, ...)

\method{changepoints}{tidycpt}(x, use_labels = FALSE, ...)

\method{changepoints}{ga}(x, ...)

\method{changepoints}{cpt}(x, ...)

\method{changepoints}{cptga}(x, ...)

\method{changepoints}{segmented}(x, ...)

\method{changepoints}{breakpointsfull}(x, ...)

\method{changepoints}{wbs}(x, ...)
}
\arguments{
\item{x}{A \linkS4class{tidycpt}, \code{segmenter}, or \link{mod_cpt} object}

\item{...}{arguments passed to methods}

\item{use_labels}{return the time labels for the changepoints instead of the
indices.}
}
\value{
a numeric vector of changepoint indices, or, if \code{use_labels} is
\code{TRUE}, a \code{character} of time labels.
}
\description{
Retrieve the indices of the changepoints identified by an algorithm or model.
}
\details{
\linkS4class{tidycpt} objects, as well as their \code{segmenter} and \code{model} components,
implement \code{\link[=changepoints]{changepoints()}} methods.

Note that this function is not to be confused with \code{\link[wbs:changepoints]{wbs::changepoints()}},
which returns different information.

For the \code{default} method, \code{\link[=changepoints]{changepoints()}} will attempt to return the
\code{cpt_true} attribute, which is set by \code{\link[=test_set]{test_set()}}.
}
\examples{
cpts <- segment(DataCPSim, method = "ga", maxiter = 5)
changepoints(cpts$segmenter)

\donttest{
# Segment a times series using a genetic algorithm
cpts <- segment(DataCPSim, method = "cptga")
changepoints(cpts$segmenter)
}
cpts <- segment(DataCPSim, method = "segmented")
changepoints(cpts$segmenter)

cpts <- segment(DataCPSim, method = "strucchange")
changepoints(cpts$segmenter)

cpts <- segment(DataCPSim, method = "wbs")
changepoints(cpts$segmenter)

}
\seealso{
\code{\link[wbs:changepoints]{wbs::changepoints()}}

Other tidycpt-generics: 
\code{\link{as.model}()},
\code{\link{as.segmenter}()},
\code{\link{diagnose}()},
\code{\link{fitness}()},
\code{\link{model_name}()}
}
\concept{tidycpt-generics}
