% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised-hclust.R
\name{tidy_hclust}
\alias{tidy_hclust}
\title{Tidy Hierarchical Clustering}
\usage{
tidy_hclust(data, method = "average", distance = "euclidean", cols = NULL)
}
\arguments{
\item{data}{A data frame, tibble, or dist object}

\item{method}{Agglomeration method: "ward.D2", "single", "complete", "average" (default), "mcquitty", "median", "centroid"}

\item{distance}{Distance metric if data is not a dist object (default: "euclidean")}

\item{cols}{Columns to include (tidy select). If NULL, uses all numeric columns.}
}
\value{
A list of class "tidy_hclust" containing:
\itemize{
\item model: hclust object
\item dist: distance matrix used
\item method: linkage method used
\item data: original data (for plotting)
}
}
\description{
Performs hierarchical clustering with tidy output
}
\examples{
# Basic hierarchical clustering
hc_result <- tidy_hclust(USArrests, method = "average")

# With specific distance
hc_result <- tidy_hclust(mtcars, method = "complete", distance = "manhattan")

}
