% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised-mds.R
\name{tidy_mds}
\alias{tidy_mds}
\title{Tidy Multidimensional Scaling}
\usage{
tidy_mds(data, method = "classical", ndim = 2, distance = "euclidean", ...)
}
\arguments{
\item{data}{A data frame, tibble, or distance matrix}

\item{method}{Character; "classical" (default), "metric", "nonmetric", "sammon", or "kruskal"}

\item{ndim}{Number of dimensions for output (default: 2)}

\item{distance}{Character; distance metric if data is not already a dist object (default: "euclidean")}

\item{...}{Additional arguments passed to specific MDS functions}
}
\value{
A list of class "tidy_mds" containing:
\itemize{
\item config: tibble of MDS configuration (coordinates)
\item stress: goodness-of-fit measure (if applicable)
\item method: character string of method used
\item model: original model object
}
}
\description{
Unified interface for MDS methods with tidy output
}
\examples{
# Classical MDS
mds_result <- tidy_mds(eurodist, method = "classical")
print(mds_result)

}
