% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsupervised-pca.R
\name{tidy_pca}
\alias{tidy_pca}
\title{Tidy Principal Component Analysis}
\usage{
tidy_pca(data, cols = NULL, scale = TRUE, center = TRUE, method = "prcomp")
}
\arguments{
\item{data}{A data frame or tibble}

\item{cols}{Columns to include in PCA (tidy select syntax). If NULL, uses all numeric columns.}

\item{scale}{Logical; should variables be scaled to unit variance? Default TRUE.}

\item{center}{Logical; should variables be centered? Default TRUE.}

\item{method}{Character; "prcomp" (default, recommended) or "princomp"}
}
\value{
A list of class "tidy_pca" containing:
\itemize{
\item scores: tibble of PC scores with observation identifiers
\item loadings: tibble of variable loadings in long format
\item variance: tibble of variance explained by each PC
\item model: the original prcomp/princomp object
\item settings: list of scale, center, method used
}
}
\description{
Performs PCA on a dataset using tidyverse principles. Returns a tidy list
containing scores, loadings, variance explained, and the original model.
}
\examples{
# Basic PCA
pca_result <- tidy_pca(USArrests)


# Access components
pca_result$scores
pca_result$loadings
pca_result$variance

}
