% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-selection.R
\name{tl_step_selection}
\alias{tl_step_selection}
\title{Perform stepwise selection on a linear model}
\usage{
tl_step_selection(
  data,
  formula,
  direction = "backward",
  criterion = "AIC",
  trace = FALSE,
  steps = 1000,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the initial model}

\item{direction}{Direction of stepwise selection: "forward", "backward", or "both"}

\item{criterion}{Criterion for selection: "AIC" or "BIC"}

\item{trace}{Logical; whether to print progress}

\item{steps}{Maximum number of steps to take}

\item{...}{Additional arguments to pass to step()}
}
\value{
A selected model
}
\description{
Perform stepwise selection on a linear model
}
